/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.LocalePrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.intl.JSLocale;
import com.oracle.truffle.js.runtime.builtins.intl.JSLocaleObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.DateTimePatternGenerator;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.text.NumberingSystem;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.Calendar;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.TimeZone;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.util.ULocale;

public final class LocalePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<LocalePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new LocalePrototypeBuiltins();

    protected LocalePrototypeBuiltins() {
        super(JSLocale.PROTOTYPE_NAME, LocalePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, LocalePrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return LocalePrototypeBuiltinsFactory.JSLocaleMaximizeNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return LocalePrototypeBuiltinsFactory.JSLocaleMinimizeNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 2: {
                return LocalePrototypeBuiltinsFactory.JSLocaleToStringNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 3: {
                return LocalePrototypeBuiltinsFactory.JSLocaleBaseNameAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 4: {
                return LocalePrototypeBuiltinsFactory.JSLocaleCalendarAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 5: {
                return LocalePrototypeBuiltinsFactory.JSLocaleCaseFirstAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 6: {
                return LocalePrototypeBuiltinsFactory.JSLocaleCollationAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 7: {
                return LocalePrototypeBuiltinsFactory.JSLocaleFirstDayOfWeekAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 8: {
                return LocalePrototypeBuiltinsFactory.JSLocaleHourCycleAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 9: {
                return LocalePrototypeBuiltinsFactory.JSLocaleNumericAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 10: {
                return LocalePrototypeBuiltinsFactory.JSLocaleNumberingSystemAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 11: {
                return LocalePrototypeBuiltinsFactory.JSLocaleLanguageAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 12: {
                return LocalePrototypeBuiltinsFactory.JSLocaleScriptAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 13: {
                return LocalePrototypeBuiltinsFactory.JSLocaleRegionAccessorNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 14: {
                return LocalePrototypeBuiltinsFactory.JSLocaleGetCalendarsNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 15: {
                return LocalePrototypeBuiltinsFactory.JSLocaleGetCollationsNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 16: {
                return LocalePrototypeBuiltinsFactory.JSLocaleGetHourCyclesNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 17: {
                return LocalePrototypeBuiltinsFactory.JSLocaleGetNumberingSystemsNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 18: {
                return LocalePrototypeBuiltinsFactory.JSLocaleGetTimeZonesNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 19: {
                return LocalePrototypeBuiltinsFactory.JSLocaleGetTextInfoNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 20: {
                return LocalePrototypeBuiltinsFactory.JSLocaleGetWeekInfoNodeGen.create(context, builtin, LocalePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum LocalePrototype implements BuiltinEnum<LocalePrototype>
    {
        maximize(0),
        minimize(0),
        toString(0),
        baseName(0),
        calendar(0),
        caseFirst(0),
        collation(0),
        firstDayOfWeek(0),
        hourCycle(0),
        numeric(0),
        numberingSystem(0),
        language(0),
        script(0),
        region(0),
        getCalendars(0),
        getCollations(0),
        getHourCycles(0),
        getNumberingSystems(0),
        getTimeZones(0),
        getTextInfo(0),
        getWeekInfo(0);

        private final int length;

        private LocalePrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return baseName.ordinal() <= this.ordinal() && this.ordinal() <= region.ordinal();
        }

        @Override
        public int getECMAScriptVersion() {
            if (getCalendars.ordinal() <= this.ordinal()) {
                return 16;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }
    }

    public static abstract class JSLocaleMaximizeNode
    extends JSBuiltinNode {
        public JSLocaleMaximizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            String maximizedLocale = localeObject.getInternalState().maximize();
            return JSFunction.construct(this.getRealm().getLocaleConstructor(), new Object[]{Strings.fromJavaString(maximizedLocale)});
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleMinimizeNode
    extends JSBuiltinNode {
        public JSLocaleMinimizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            String minimizedLocale = localeObject.getInternalState().minimize();
            return JSFunction.construct(this.getRealm().getLocaleConstructor(), new Object[]{Strings.fromJavaString(minimizedLocale)});
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleToStringNode
    extends JSBuiltinNode {
        public JSLocaleToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public TruffleString doLocale(JSLocaleObject localeObject) {
            return Strings.fromJavaString(localeObject.getInternalState().getLocale());
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public TruffleString doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleBaseNameAccessor
    extends JSBuiltinNode {
        public JSLocaleBaseNameAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public TruffleString doLocale(JSLocaleObject localeObject) {
            return Strings.fromJavaString(localeObject.getInternalState().getBaseName());
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public String doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleCalendarAccessor
    extends JSBuiltinNode {
        public JSLocaleCalendarAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            String calendar = localeObject.getInternalState().getCalendar();
            if (calendar == null) {
                return Undefined.instance;
            }
            return Strings.fromJavaString(calendar);
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleCaseFirstAccessor
    extends JSBuiltinNode {
        public JSLocaleCaseFirstAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            String caseFirst = localeObject.getInternalState().getCaseFirst();
            if (caseFirst == null) {
                return Undefined.instance;
            }
            return Strings.fromJavaString(caseFirst);
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleCollationAccessor
    extends JSBuiltinNode {
        public JSLocaleCollationAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            String collation = localeObject.getInternalState().getCollation();
            if (collation == null) {
                return Undefined.instance;
            }
            return Strings.fromJavaString(collation);
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleFirstDayOfWeekAccessor
    extends JSBuiltinNode {
        public JSLocaleFirstDayOfWeekAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            int fw = localeObject.getInternalState().getFirstDayOfWeek();
            return fw == -1 ? Undefined.instance : Integer.valueOf(fw);
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleHourCycleAccessor
    extends JSBuiltinNode {
        public JSLocaleHourCycleAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            String hourCycle = localeObject.getInternalState().getHourCycle();
            if (hourCycle == null) {
                return Undefined.instance;
            }
            return Strings.fromJavaString(hourCycle);
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleNumericAccessor
    extends JSBuiltinNode {
        public JSLocaleNumericAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public boolean doLocale(JSLocaleObject localeObject) {
            return localeObject.getInternalState().getNumeric();
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public boolean doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleNumberingSystemAccessor
    extends JSBuiltinNode {
        public JSLocaleNumberingSystemAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            String numberingSystem = localeObject.getInternalState().getNumberingSystem();
            if (numberingSystem == null) {
                return Undefined.instance;
            }
            return Strings.fromJavaString(numberingSystem);
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleLanguageAccessor
    extends JSBuiltinNode {
        public JSLocaleLanguageAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            String language = localeObject.getInternalState().getLanguage();
            return language.isEmpty() ? Undefined.instance : Strings.fromJavaString(language);
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleScriptAccessor
    extends JSBuiltinNode {
        public JSLocaleScriptAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            String script = localeObject.getInternalState().getScript();
            return script.isEmpty() ? Undefined.instance : Strings.fromJavaString(script);
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleRegionAccessor
    extends JSBuiltinNode {
        public JSLocaleRegionAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            String region = localeObject.getInternalState().getRegion();
            return region.isEmpty() ? Undefined.instance : Strings.fromJavaString(region);
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleGetCalendarsNode
    extends JSBuiltinNode {
        public JSLocaleGetCalendarsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            ULocale locale = localeObject.getInternalState().getULocale();
            String calendar = locale.getUnicodeLocaleType("ca");
            String[] calendars = calendar == null ? IntlUtil.availableCalendars(locale, true) : new String[]{calendar};
            return JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), Strings.convertJavaStringArray(calendars));
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleGetCollationsNode
    extends JSBuiltinNode {
        public JSLocaleGetCollationsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            ULocale locale = localeObject.getInternalState().getULocale();
            String collation = locale.getUnicodeLocaleType("co");
            String[] collations = collation == null ? IntlUtil.availableCollations(locale, true) : new String[]{collation};
            return JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), Strings.convertJavaStringArray(collations));
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleGetHourCyclesNode
    extends JSBuiltinNode {
        public JSLocaleGetHourCyclesNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            ULocale locale = localeObject.getInternalState().getULocale();
            String hourCycle = locale.getUnicodeLocaleType("hc");
            if (hourCycle == null) {
                DateTimePatternGenerator patternGenerator = DateTimePatternGenerator.getInstance(locale);
                hourCycle = IntlUtil.toJSHourCycle(patternGenerator.getDefaultHourCycle());
            }
            return JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), new Object[]{Strings.fromJavaString(hourCycle)});
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleGetNumberingSystemsNode
    extends JSBuiltinNode {
        public JSLocaleGetNumberingSystemsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            ULocale locale = localeObject.getInternalState().getULocale();
            String numberingSystem = locale.getUnicodeLocaleType("nu");
            if (numberingSystem == null) {
                numberingSystem = NumberingSystem.getInstance(locale).getName();
            }
            return JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), new Object[]{Strings.fromJavaString(numberingSystem)});
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleGetTimeZonesNode
    extends JSBuiltinNode {
        public JSLocaleGetTimeZonesNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            ULocale locale = localeObject.getInternalState().getULocale();
            String region = locale.getCountry();
            if (region.isEmpty()) {
                return Undefined.instance;
            }
            Set<String> timeZoneSet = TimeZone.getAvailableIDs(TimeZone.SystemTimeZoneType.CANONICAL, region, null);
            Object[] timeZones = new Object[timeZoneSet.size()];
            int i2 = 0;
            for (String timeZone : timeZoneSet) {
                timeZones[i2++] = Strings.fromJavaString(timeZone);
            }
            return JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), timeZones);
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }
    }

    public static abstract class JSLocaleGetTextInfoNode
    extends JSBuiltinNode {
        @Node.Child
        CreateDataPropertyNode createDirectionNode;

        public JSLocaleGetTextInfoNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createDirectionNode = CreateDataPropertyNode.create(context, IntlUtil.KEY_DIRECTION);
        }

        @Specialization
        public Object doLocale(JSLocaleObject localeObject) {
            JSObject textInfo = JSOrdinary.create(this.getContext(), this.getRealm());
            this.createDirectionNode.executeVoid(textInfo, JSLocaleGetTextInfoNode.direction(localeObject));
            return textInfo;
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString direction(JSLocaleObject localeObject) {
            ULocale locale = localeObject.getInternalState().getULocale();
            return locale.isRightToLeft() ? IntlUtil.KEY_RTL : IntlUtil.KEY_LTR;
        }
    }

    public static abstract class JSLocaleGetWeekInfoNode
    extends JSBuiltinNode {
        @Node.Child
        CreateDataPropertyNode createFirstDayNode;
        @Node.Child
        CreateDataPropertyNode createWeekendNode;
        @Node.Child
        CreateDataPropertyNode createMinimalDaysNode;

        public JSLocaleGetWeekInfoNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createFirstDayNode = CreateDataPropertyNode.create(context, IntlUtil.KEY_FIRST_DAY);
            this.createWeekendNode = CreateDataPropertyNode.create(context, IntlUtil.KEY_WEEKEND);
            this.createMinimalDaysNode = CreateDataPropertyNode.create(context, IntlUtil.KEY_MINIMAL_DAYS);
        }

        @Specialization
        public Object doLocale(JSLocaleObject localeObject, @Cached InlinedBranchProfile growProfile) {
            Calendar.WeekData weekData = JSLocaleGetWeekInfoNode.weekData(localeObject);
            int fw = localeObject.getInternalState().getFirstDayOfWeek();
            int firstDay = fw == -1 ? JSLocaleGetWeekInfoNode.calendarToECMAScriptDay(weekData.firstDayOfWeek) : fw;
            int minimalDays = weekData.minimalDaysInFirstWeek;
            SimpleArrayList<Integer> weekendList = new SimpleArrayList<Integer>(7);
            int weekendCease = weekData.weekendCease;
            int day = weekData.weekendOnset;
            while (true) {
                weekendList.add(JSLocaleGetWeekInfoNode.calendarToECMAScriptDay(day), this, growProfile);
                if (day == weekendCease) break;
                if (day == 7) {
                    day = 1;
                    continue;
                }
                ++day;
            }
            JSContext context = this.getContext();
            JSRealm realm = this.getRealm();
            JSArrayObject weekend = JSArray.createConstantObjectArray(context, realm, weekendList.toArray());
            JSObject weekInfo = JSOrdinary.create(context, realm);
            this.createFirstDayNode.executeVoid(weekInfo, firstDay);
            this.createWeekendNode.executeVoid(weekInfo, weekend);
            this.createMinimalDaysNode.executeVoid(weekInfo, minimalDays);
            return weekInfo;
        }

        @Specialization(guards={"!isJSLocale(bummer)"})
        public Object doOther(Object bummer) {
            throw Errors.createTypeErrorLocaleExpected();
        }

        @CompilerDirectives.TruffleBoundary
        private static Calendar.WeekData weekData(JSLocaleObject localeObject) {
            ULocale locale = localeObject.getInternalState().getULocale();
            return Calendar.getInstance(locale).getWeekData();
        }

        private static int calendarToECMAScriptDay(int day) {
            return day == 1 ? 7 : day - 1;
        }
    }
}

