/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.math.MathOperation;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;

public abstract class AtanhNode
extends MathOperation {
    public AtanhNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected static double atanh(double x2) {
        if (JSRuntime.isNegativeZero(x2)) {
            return -0.0;
        }
        return Math.log((1.0 + x2) / (1.0 - x2)) / 2.0;
    }

    @Specialization
    protected double atanh(Object a2) {
        return AtanhNode.atanh(this.toDouble(a2));
    }
}

