/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.math.MathOperation;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;

public abstract class FloorNode
extends MathOperation {
    public FloorNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected static int floorInt(int a2) {
        return a2;
    }

    @Specialization
    protected static SafeInteger floorSafeInt(SafeInteger a2) {
        return a2;
    }

    @Specialization
    protected final Object floorDouble(double d2, @Cached @Cached.Shared InlinedConditionProfile isZero, @Cached @Cached.Shared InlinedConditionProfile fitsInt, @Cached @Cached.Shared InlinedConditionProfile fitsSafeLong, @Cached @Cached.Shared InlinedConditionProfile smaller) {
        if (isZero.profile(this, d2 == 0.0)) {
            return d2;
        }
        if (fitsInt.profile(this, d2 >= -2.147483648E9 && d2 <= 2.147483647E9)) {
            int i2 = (int)d2;
            return smaller.profile(this, d2 < (double)i2) ? i2 - 1 : i2;
        }
        if (fitsSafeLong.profile(this, JSRuntime.isSafeInteger(d2))) {
            long i3 = (long)d2;
            long result = smaller.profile(this, d2 < (double)i3) ? i3 - 1L : i3;
            return SafeInteger.valueOf(result);
        }
        return Math.floor(d2);
    }

    @Specialization(replaces={"floorDouble"})
    protected final Object floorToDouble(Object a2, @Cached @Cached.Shared InlinedConditionProfile isZero, @Cached @Cached.Shared InlinedConditionProfile fitsInt, @Cached @Cached.Shared InlinedConditionProfile fitsSafeLong, @Cached @Cached.Shared InlinedConditionProfile smaller) {
        double d2 = this.toDouble(a2);
        return this.floorDouble(d2, isZero, fitsInt, fitsSafeLong, smaller);
    }
}

