/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.array.TypedArrayLengthNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;

@ImportStatic(value={JSArrayBufferView.class})
@GenerateInline
@GenerateCached(value=false)
public abstract class ArrayBufferViewGetByteLengthNode
extends JavaScriptBaseNode {
    protected ArrayBufferViewGetByteLengthNode() {
    }

    public abstract int executeInt(Node var1, JSTypedArrayObject var2, JSContext var3);

    @Specialization(guards={"!isOutOfBounds(obj, context)", "cachedArray == obj.getArrayType()"}, limit="1")
    protected static int getByteLengthCached(JSTypedArrayObject obj, JSContext context, @Cached(value="obj.getArrayType()") TypedArray cachedArray) {
        return cachedArray.lengthInt(obj) << cachedArray.bytesPerElementShift();
    }

    @Specialization(replaces={"getByteLengthCached"})
    protected static int getByteLength(Node node, JSTypedArrayObject typedArray, JSContext context, @Cached TypedArrayLengthNode typedArrayLengthNode) {
        return typedArrayLengthNode.execute(node, typedArray, context) << typedArray.getArrayType().bytesPerElementShift();
    }

    @NeverDefault
    protected static TypedArray getArrayType(JSTypedArrayObject obj) {
        return JSArrayBufferView.typedArrayGetArrayType(obj);
    }
}

