/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.array.ArrayBufferByteLengthNode;
import com.oracle.truffle.js.nodes.array.TypedArrayLengthNodeGen;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;

@ImportStatic(value={JSArrayBufferView.class})
@GenerateInline(inlineByDefault=true)
public abstract class TypedArrayLengthNode
extends JavaScriptBaseNode {
    public abstract int execute(Node var1, JSTypedArrayObject var2, JSContext var3);

    @Specialization(guards={"!isOutOfBounds(typedArray, context)", "!typedArray.hasAutoLength()"})
    protected static int doFixedLength(JSTypedArrayObject typedArray, JSContext context) {
        assert (!JSArrayBufferView.isOutOfBounds(typedArray, context));
        return typedArray.getLengthFixed();
    }

    @Specialization(guards={"!isOutOfBounds(typedArray, context)", "typedArray.hasAutoLength()"})
    protected static int doAutoLength(Node node, JSTypedArrayObject typedArray, JSContext context, @Cached ArrayBufferByteLengthNode getByteLengthNode) {
        assert (!JSArrayBufferView.isOutOfBounds(typedArray, context));
        JSArrayBufferObject arrayBuffer = typedArray.getArrayBuffer();
        int byteLength = getByteLengthNode.execute(node, arrayBuffer, context);
        int byteOffset = typedArray.getOffset();
        return byteLength - byteOffset >> typedArray.getArrayType().bytesPerElementShift();
    }

    @Specialization(guards={"isOutOfBounds(typedArray, context)"})
    protected static int doOutOfBounds(JSTypedArrayObject typedArray, JSContext context) {
        return 0;
    }

    @NeverDefault
    public static TypedArrayLengthNode create() {
        return TypedArrayLengthNodeGen.create();
    }
}

