/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.cast.IsNumberNode;
import com.oracle.truffle.js.runtime.SafeInteger;

@GeneratedBy(value=IsNumberNode.class)
public final class IsNumberNodeGen {
    @NeverDefault
    public static IsNumberNode inline(@InlineSupport.RequiredField(bits=7, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
        return new Inlined(target);
    }

    @GeneratedBy(value=IsNumberNode.class)
    @DenyReplace
    private static final class Inlined
    extends IsNumberNode
    implements UnadoptableNode {
        private final InlineSupport.StateField state_0_;

        private Inlined(InlineSupport.InlineTarget target) {
            assert (target.getTargetClass().isAssignableFrom(IsNumberNode.class));
            this.state_0_ = target.getState(0, 7);
        }

        private boolean fallbackGuard_(Node arg0Value, Object arg1Value) {
            return !JSTypesGen.isImplicitDouble(arg1Value);
        }

        @Override
        public boolean execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0xF) != 0) {
                if ((state_0 & 1) != 0 && arg1Value instanceof Integer) {
                    int arg1Value_ = (Integer)arg1Value;
                    return IsNumberNode.doInt(arg1Value_);
                }
                if ((state_0 & 2) != 0 && arg1Value instanceof SafeInteger) {
                    SafeInteger arg1Value_ = (SafeInteger)arg1Value;
                    return IsNumberNode.doSafeInteger(arg1Value_);
                }
                if ((state_0 & 4) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x70) >>> 4, arg1Value)) {
                    double arg1Value_ = JSTypesGen.asImplicitDouble((state_0 & 0x70) >>> 4, arg1Value);
                    return IsNumberNode.doDouble(arg1Value_);
                }
                if ((state_0 & 8) != 0 && this.fallbackGuard_(arg0Value, arg1Value)) {
                    return IsNumberNode.doOther(arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (Integer)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 1);
                return IsNumberNode.doInt(arg1Value_);
            }
            if (arg1Value instanceof SafeInteger) {
                SafeInteger arg1Value_ = (SafeInteger)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 2);
                return IsNumberNode.doSafeInteger(arg1Value_);
            }
            int doubleCast1 = JSTypesGen.specializeImplicitDouble(arg1Value);
            if (doubleCast1 != 0) {
                double arg1Value_ = JSTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                state_0 |= doubleCast1 << 4;
                this.state_0_.set(arg0Value, state_0 |= 4);
                return IsNumberNode.doDouble(arg1Value_);
            }
            this.state_0_.set(arg0Value, state_0 |= 8);
            return IsNumberNode.doOther(arg1Value);
        }
    }
}

