/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.java.JavaImporterObject;
import com.oracle.truffle.js.runtime.java.JavaPackage;
import com.oracle.truffle.js.runtime.java.JavaPackageObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JavaImporter
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("JavaImporter");
    private static final JavaImporter INSTANCE = new JavaImporter();

    private JavaImporter() {
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    public static JavaImporterObject create(JSContext context, JSRealm realm, Object[] value) {
        JSObjectFactory factory = context.getJavaImporterFactory();
        JSDynamicObject proto = factory.getPrototype(realm);
        Shape shape = factory.getShape(realm, proto);
        JavaImporterObject newObj = factory.initProto(new JavaImporterObject(shape, proto, value), realm, proto);
        return factory.trackAllocation(newObj);
    }

    public static boolean isJavaImporter(Object obj) {
        return obj instanceof JavaImporterObject;
    }

    @Override
    public boolean hasOwnProperty(JSDynamicObject thisObj, Object name) {
        return this.getOwnHelper(thisObj, (Object)thisObj, name, null) != null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(JSDynamicObject store, Object thisObj, Object key, Node encapsulatingNode) {
        if (key instanceof TruffleString) {
            TruffleString name = (TruffleString)key;
            Object[] imports = JavaImporter.getImports(store);
            JSRealm realm = JSRealm.get(null);
            for (int i2 = imports.length - 1; i2 >= 0; --i2) {
                Object anImport = imports[i2];
                if (anImport instanceof JavaPackageObject) {
                    JavaPackageObject javaPackage = (JavaPackageObject)anImport;
                    Object found = JavaPackage.lookupClass(realm, javaPackage, name);
                    if (found == null) continue;
                    return found;
                }
                try {
                    if (!Strings.equals(name, Strings.interopAsTruffleString(InteropLibrary.getUncached().getMetaSimpleName(anImport)))) continue;
                    return anImport;
                }
                catch (UnsupportedMessageException e2) {
                    throw Errors.createTypeErrorInteropException(anImport, e2, "getSimpleName", null);
                }
            }
        }
        return null;
    }

    public static Object[] getImports(JSDynamicObject importer) {
        assert (JavaImporter.isJavaImporter(importer));
        return ((JavaImporterObject)importer).getImports();
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putToStringTag(prototype, CLASS_NAME);
        JSObjectUtil.putConstructorProperty(prototype, ctor);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, JavaImporter.instance(), context);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return JavaImporter.instance().createConstructorAndPrototype(realm);
    }

    public static JavaImporter instance() {
        return INSTANCE;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getJavaImporterPrototype();
    }
}

