/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;

@CompilerDirectives.ValueType
public final class IteratorRecord {
    private final Object iterator;
    private final Object nextMethod;
    private boolean done;

    private IteratorRecord(Object iterator, Object nextMethod, boolean done) {
        this.iterator = iterator;
        this.nextMethod = nextMethod;
        this.done = done;
    }

    public static IteratorRecord create(Object iterator, Object nextMethod, boolean done) {
        return new IteratorRecord(iterator, nextMethod, done);
    }

    public static IteratorRecord create(Object iterator, Object nextMethod) {
        return IteratorRecord.create(iterator, nextMethod, false);
    }

    public Object getIterator() {
        return this.iterator;
    }

    public Object getNextMethod() {
        return this.nextMethod;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return "IteratorRecord{iterator=" + String.valueOf(this.iterator) + ", done=" + this.done + ", next=" + String.valueOf(this.nextMethod) + "}";
    }
}

