/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

public final class Flags {
    static final int DEFAULT = 0;
    static final int IMPLICIT_CAST_INT_TO_LONG = 1;
    static final int IMPLICIT_CAST_INT_TO_DOUBLE = 2;
    static final int IF_PRESENT = 4;
    static final int IF_ABSENT = 8;
    static final int UPDATE_FLAGS = 16;
    static final int CONST = 32;
    static final int DECLARE = 64;
    static final int SEPARATE_SHAPE = 128;

    private Flags() {
    }

    private static boolean getFlag(int flags, int flagBit) {
        return (flags & flagBit) != 0;
    }

    public static boolean isImplicitCastIntToLong(int flags) {
        return Flags.getFlag(flags, 1);
    }

    public static boolean isImplicitCastIntToDouble(int flags) {
        return Flags.getFlag(flags, 2);
    }

    public static boolean isSetExisting(int flags) {
        return Flags.getFlag(flags, 4);
    }

    public static boolean isUpdateFlags(int flags) {
        return Flags.getFlag(flags, 16);
    }

    public static boolean isConstant(int flags) {
        return Flags.getFlag(flags, 32);
    }

    public static boolean isDeclaration(int flags) {
        return Flags.getFlag(flags, 64);
    }

    public static boolean isSeparateShape(int flags) {
        return Flags.getFlag(flags, 128);
    }
}

