/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.polyglot.enterprise.BinaryProtocol;
import com.oracle.truffle.polyglot.enterprise.CleanableWeakReference;
import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineAccessor;
import com.oracle.truffle.polyglot.enterprise.HSContext;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolate;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import com.oracle.truffle.polyglot.enterprise.StackPointerRetriever;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageSingletons;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.UnmanagedMemory;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.WordFactory;

@ExportLibrary(value=ReflectionLibrary.class)
final class HSTruffleObject
implements TruffleObject {
    private static final BinaryMarshaller<Throwable> THROWABLE_MARSHALLER = PolyglotJNIConfig.getInstance().lookupMarshaller(Throwable.class, new Class[0]);
    private static final Message MESSAGE_READ_BUFFER = Message.resolve(InteropLibrary.class, "readBuffer");
    private final HSContext context;
    private final long hostReferenceId;

    private HSTruffleObject(HSContext hSContext, long l2) {
        this.context = hSContext;
        this.hostReferenceId = l2;
    }

    long getHostReferenceId() {
        return this.hostReferenceId;
    }

    public static HSTruffleObject createHostObjectReference(long l2, HSContext hSContext) {
        if (ImageSingletons.contains(PolyglotIsolateGuestFeatureEnabled.class)) {
            HSTruffleObject hSTruffleObject = new HSTruffleObject(hSContext, l2);
            new CleanupReference(hSTruffleObject, hSContext, l2);
            return hSTruffleObject;
        }
        throw new UnsupportedOperationException("Should not reach here.");
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object send(Message message, Object[] objectArray) {
        JNI.JByteArray jByteArray;
        JNI.JByteArray jByteArray2;
        Object object;
        JNI.JNIEnv jNIEnv = JNIMethodScope.env();
        if (!StackPointerRetriever.fitsOnStack(this.context.hostStackSpaceHeadroom, PolyglotIsolate.getHostStackOverflowLimit())) {
            throw new StackOverflowError("Not enough stack space to perform a host call from isolated guest language.");
        }
        CCharPointer cCharPointer = (CCharPointer)StackValue.get(4096);
        boolean bl = objectArray.length > 0;
        byte[] byArray = null;
        int n2 = -1;
        if (message == MESSAGE_READ_BUFFER) {
            byArray = (byte[])objectArray[1];
            n2 = (Integer)objectArray[2];
            objectArray[1] = null;
            objectArray[2] = 0;
        }
        if (bl) {
            object = BinaryOutput.create(cCharPointer, 4096, false);
            try {
                BinaryProtocol.writeGuestTypedValue((BinaryOutput)object, objectArray, this.context.hostToGuestObjectReferences);
                int n3 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                jByteArray2 = JNIUtil.NewByteArray(jNIEnv, n3);
                JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray2, 0, n3, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
            }
            finally {
                if (object != null) {
                    ((BinaryOutput.CCharPointerBinaryOutput)object).close();
                }
            }
        } else {
            jByteArray2 = (JNI.JByteArray)WordFactory.nullPointer();
        }
        object = StackValue.get(3, JNI.JValue.class);
        object.addressOf(0).setLong(this.hostReferenceId);
        object.addressOf(1).setInt(message.getId());
        object.addressOf(2).setJObject(jByteArray2);
        try {
            jByteArray = (JNI.JByteArray)ForeignException.getJNICalls().callJObject(jNIEnv, this.context.guestToHostReceiver, this.context.guestToHostMessageDispatch, (JNI.JValue)object);
        }
        catch (ForeignException foreignException) {
            throw foreignException.throwOriginalException(THROWABLE_MARSHALLER);
        }
        if (jByteArray.isNull()) {
            return EnterpriseEngineAccessor.ENGINE.getHostNull();
        }
        int n4 = JNIUtil.GetArrayLength(jNIEnv, jByteArray);
        CCharPointer cCharPointer2 = n4 < 4096 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc(n4);
        try {
            Object object2;
            JNIUtil.GetByteArrayRegion(jNIEnv, jByteArray, 0, n4, cCharPointer2);
            BinaryInput binaryInput = BinaryInput.create(cCharPointer2, n4);
            boolean bl2 = binaryInput.readBoolean();
            Object object3 = BinaryProtocol.readGuestTypedValue(binaryInput, this.context);
            if (message == MESSAGE_READ_BUFFER && bl2) {
                object2 = (byte[])object3;
                System.arraycopy(object2, 0, byArray, n2, ((Object)object2).length);
                object3 = null;
            }
            if (bl2) {
                object2 = object3;
                return object2;
            }
            throw HSTruffleObject.throwUnchecked(RuntimeException.class, (Throwable)object3);
        }
        finally {
            if (cCharPointer2 != cCharPointer) {
                UnmanagedMemory.free(cCharPointer2);
            }
        }
    }

    private static <T extends Throwable> T throwUnchecked(Class<T> clazz, Throwable throwable) throws T {
        throw throwable;
    }

    private static class CleanupReference
    extends CleanableWeakReference<HSTruffleObject> {
        private final HSContext context;
        private final long hostObjectId;

        CleanupReference(HSTruffleObject hSTruffleObject, HSContext hSContext, long l2) {
            super(hSTruffleObject);
            this.context = hSContext;
            this.hostObjectId = l2;
        }

        @Override
        public void run() {
            try {
                this.context.releaseGuestToHostReference(this.hostObjectId);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(THROWABLE_MARSHALLER);
            }
        }
    }
}

