/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.automaton;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.automaton.StateIndex;
import com.oracle.truffle.regex.tregex.automaton.StateSetImpl;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.Assertions;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface StateSet<SI extends StateIndex<? super S>, S>
extends Set<S>,
Iterable<S>,
JsonConvertible {
    public static <SI extends StateIndex<? super S>, S> StateSet<SI, S> create(SI stateIndex) {
        return new StateSetImpl(stateIndex);
    }

    public static <SI extends StateIndex<? super S>, S> StateSet<SI, S> create(SI stateIndex, S initial) {
        StateSet<SI, S> s2 = StateSet.create(stateIndex);
        s2.add(initial);
        return s2;
    }

    public static <SI extends StateIndex<? super S>, S> StateSet<SI, S> create(SI stateIndex, Collection<S> initial) {
        StateSet<SI, S> s2 = StateSet.create(stateIndex);
        s2.addAll(initial);
        return s2;
    }

    public StateSet<SI, S> copy();

    public SI getStateIndex();

    public boolean isDisjoint(StateSet<SI, ? extends S> var1);

    @Override
    public int hashCode();

    default public int[] toArrayOfIndices() {
        int[] array = new int[this.size()];
        int i2 = 0;
        for (Object s2 : this) {
            array[i2++] = this.getStateIndex().getId(s2);
        }
        if (!1.$assertionsDisabled && !Assertions.isSorted(array)) {
            throw new AssertionError();
        }
        return array;
    }

    @Override
    default public Object[] toArray() {
        Object[] ret = new Object[this.size()];
        int i2 = 0;
        for (Object s2 : this) {
            ret[i2++] = s2;
        }
        return ret;
    }

    @Override
    default public <T> T[] toArray(T[] a2) {
        T[] r2 = a2.length >= this.size() ? a2 : (Object[])Array.newInstance(a2.getClass().getComponentType(), this.size());
        int i2 = 0;
        for (Object s2 : this) {
            r2[i2++] = s2;
        }
        return r2;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    default public Stream<S> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @CompilerDirectives.TruffleBoundary
    default public String defaultToString() {
        return this.stream().map(Object::toString).collect(Collectors.joining(",", "{", "}"));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    default public JsonValue toJson() {
        return Json.array(new JsonConvertible[]{this});
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

