/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.tregex.automaton.StateIndex;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.nfa.PureNFAState;
import com.oracle.truffle.regex.tregex.nfa.PureNFATransition;
import com.oracle.truffle.regex.tregex.parser.Counter;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;

public final class PureNFA
implements StateIndex<PureNFAState> {
    private static final PureNFA[] NO_SUBTREES = new PureNFA[0];
    private final int globalSubTreeId;
    private final int subTreeId;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PureNFAState[] states;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PureNFATransition[] transitions;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PureNFA[] subtrees;

    public PureNFA(RegexASTSubtreeRootNode astSubRoot, PureNFAState[] states, Counter.ThresholdCounter stateIDCounter, Counter.ThresholdCounter transitionIDCounter) {
        this.globalSubTreeId = astSubRoot.getGlobalSubTreeId();
        this.subTreeId = astSubRoot.getSubTreeId();
        this.states = new PureNFAState[stateIDCounter.getCount()];
        this.transitions = new PureNFATransition[transitionIDCounter.getCount()];
        this.subtrees = astSubRoot.getSubtrees().size() == 0 ? NO_SUBTREES : new PureNFA[astSubRoot.getSubtrees().size()];
        for (PureNFAState s2 : states) {
            if (s2 == null) continue;
            assert (this.states[s2.getId()] == null);
            this.states[s2.getId()] = s2;
            for (PureNFATransition t2 : (PureNFATransition[])s2.getSuccessors()) {
                assert (this.transitions[t2.getId()] == null || s2.getId() == 0 && this.transitions[t2.getId()] == t2);
                this.transitions[t2.getId()] = t2;
            }
        }
    }

    public int getSubTreeId() {
        return this.subTreeId;
    }

    public int getGlobalSubTreeId() {
        return this.globalSubTreeId;
    }

    public boolean isRoot() {
        return this.subTreeId < 0;
    }

    public RegexASTSubtreeRootNode getASTSubtree(RegexAST ast) {
        return this.isRoot() ? ast.getRoot().getSubTreeParent() : (RegexASTSubtreeRootNode)ast.getSubtrees().get(this.globalSubTreeId);
    }

    public PureNFAState getDummyInitialState() {
        assert (((PureNFATransition[])this.states[0].getSuccessors()).length == 2);
        return this.states[0];
    }

    public PureNFATransition getAnchoredEntry() {
        return ((PureNFATransition[])this.getDummyInitialState().getSuccessors())[0];
    }

    public PureNFATransition getUnAnchoredEntry() {
        return ((PureNFATransition[])this.getDummyInitialState().getSuccessors())[1];
    }

    public PureNFAState getUnAnchoredInitialState() {
        return this.getUnAnchoredEntry().getTarget();
    }

    public PureNFAState getAnchoredInitialState() {
        return this.getAnchoredEntry().getTarget();
    }

    public PureNFAState[] getStates() {
        return this.states;
    }

    public PureNFATransition[] getTransitions() {
        return this.transitions;
    }

    public PureNFA[] getSubtrees() {
        return this.subtrees;
    }

    @Override
    public int getNumberOfStates() {
        return this.states.length;
    }

    public int getNumberOfTransitions() {
        return this.transitions.length;
    }

    @Override
    public int getId(PureNFAState state) {
        assert (this.states[state.getId()] == state);
        return state.getId();
    }

    @Override
    public PureNFAState getState(int id) {
        return this.states[id];
    }

    public void materializeGroupBoundaries() {
        for (PureNFATransition t2 : this.transitions) {
            if (t2 == null) continue;
            t2.getGroupBoundaries().materializeArrays();
        }
    }

    public CodePointSet getMergedInitialStateCharSet(RegexAST ast, CompilationBuffer compilationBuffer) {
        CodePointSetAccumulator acc = compilationBuffer.getCodePointSetAccumulator1();
        if (PureNFA.mergeInitialStateMatcher(ast, this, acc)) {
            return acc.toCodePointSet();
        }
        return null;
    }

    private static boolean mergeInitialStateMatcher(RegexAST ast, PureNFA nfa, CodePointSetAccumulator acc) {
        block5: for (PureNFATransition t2 : (PureNFATransition[])nfa.getUnAnchoredInitialState().getSuccessors()) {
            PureNFAState target = t2.getTarget();
            switch (target.getKind()) {
                case 0: 
                case 3: 
                case 4: {
                    return false;
                }
                case 2: {
                    if (!target.isSubMatcherNegated() && !target.isLookBehind(ast) && PureNFA.mergeInitialStateMatcher(ast, nfa.getSubtrees()[target.getSubtreeId()], acc)) continue block5;
                    return false;
                }
                case 1: {
                    acc.addSet(target.getCharSet());
                    continue block5;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson(RegexAST ast) {
        return Json.obj(Json.prop("states", Arrays.stream(this.states).map(x2 -> x2 == null || x2 == this.getDummyInitialState() ? Json.nullValue() : x2.toJson(ast))), Json.prop("transitions", Arrays.stream(this.transitions).map(x2 -> x2 == null || x2.getSource() == this.getDummyInitialState() ? Json.nullValue() : x2.toJson(ast))), Json.prop("subtrees", Arrays.stream(this.subtrees).map(x2 -> x2 == null ? Json.nullValue() : x2.toJson(ast))), Json.prop("anchoredEntry", Json.array(Json.val(this.getAnchoredInitialState().getId()))), Json.prop("unAnchoredEntry", Json.array(Json.val(this.getUnAnchoredInitialState().getId()))));
    }
}

