/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.util.Abstract128BitSet;
import com.oracle.truffle.regex.util.Assertions;
import com.oracle.truffle.regex.util.BitSets;
import java.util.Arrays;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public class TBitSet
implements Iterable<Integer> {
    private static final TBitSet[] STATIC_INSTANCES = new TBitSet[16];
    private long[] words;

    public static TBitSet valueOf(int ... values) {
        assert (values.length > 0);
        assert (Assertions.isSorted(values));
        TBitSet bs = new TBitSet(values[values.length - 1]);
        for (int v2 : values) {
            bs.set(v2);
        }
        return bs;
    }

    public TBitSet(int nbits) {
        this.words = BitSets.createBitSetArray(nbits);
    }

    private TBitSet(long[] words) {
        this.words = words;
    }

    private TBitSet(TBitSet copy) {
        this.words = Arrays.copyOf(copy.words, copy.words.length);
    }

    public static TBitSet getEmptyInstance() {
        return STATIC_INSTANCES[0];
    }

    public static TBitSet getStaticInstance(int i2) {
        return STATIC_INSTANCES[i2];
    }

    public static int getNumberOfStaticInstances() {
        return STATIC_INSTANCES.length;
    }

    public int getStaticCacheKey() {
        for (int i2 = 1; i2 < this.words.length; ++i2) {
            if (this.words[i2] == 0L) continue;
            return -1;
        }
        if (this.words.length == 0) {
            return 0;
        }
        return 0L <= this.words[0] && this.words[0] < (long)STATIC_INSTANCES.length ? (int)this.words[0] : -1;
    }

    public TBitSet copy() {
        return new TBitSet(this);
    }

    public long[] toLongArray() {
        return Arrays.copyOf(this.words, this.words.length);
    }

    public long[] getInternalArray() {
        return this.words;
    }

    private void ensureCapacity(int nWords) {
        if (this.words.length < nWords) {
            this.words = Arrays.copyOf(this.words, Math.max(2 * this.words.length, nWords));
        }
    }

    public boolean isEmpty() {
        return BitSets.isEmpty(this.words);
    }

    public boolean isFull() {
        return BitSets.isFull(this.words);
    }

    public int numberOfSetBits() {
        return BitSets.size(this.words);
    }

    public boolean get(int b2) {
        return BitSets.get(this.words, b2);
    }

    public void set(int b2) {
        this.ensureCapacity(BitSets.wordIndex(b2) + 1);
        BitSets.set(this.words, b2);
    }

    public void setRange(int lo, int hi) {
        this.ensureCapacity(BitSets.wordIndex(hi) + 1);
        BitSets.setRange(this.words, lo, hi);
    }

    public void clearRange(int lo, int hi) {
        this.ensureCapacity(BitSets.wordIndex(hi) + 1);
        BitSets.clearRange(this.words, lo, hi);
    }

    public void clear() {
        BitSets.clear(this.words);
    }

    public void clear(int index) {
        this.ensureCapacity(BitSets.wordIndex(index) + 1);
        BitSets.clear(this.words, index);
    }

    public void invert() {
        BitSets.invert(this.words);
    }

    public void intersect(TBitSet other) {
        BitSets.intersect(this.words, other.words);
    }

    public void subtract(TBitSet other) {
        BitSets.subtract(this.words, other.words);
    }

    public void union(TBitSet other) {
        this.ensureCapacity(other.words.length);
        BitSets.union(this.words, other.words);
    }

    public void union(Abstract128BitSet bs) {
        this.ensureCapacity(2);
        this.words[0] = this.words[0] | bs.getLo();
        this.words[1] = this.words[1] | bs.getHi();
    }

    public boolean isDisjoint(TBitSet other) {
        return BitSets.isDisjoint(this.words, other.words);
    }

    public boolean contains(TBitSet other) {
        return BitSets.contains(this.words, other.words);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TBitSet)) {
            return false;
        }
        TBitSet o2 = (TBitSet)obj;
        return BitSets.equals(this.words, o2.words);
    }

    public int hashCode() {
        return BitSets.hashCode(this.words);
    }

    public PrimitiveIterator.OfInt iterator() {
        return BitSets.iterator(this.words);
    }

    @CompilerDirectives.TruffleBoundary
    public Spliterator.OfInt spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 277);
    }

    @CompilerDirectives.TruffleBoundary
    public IntStream stream() {
        return StreamSupport.intStream(this.spliterator(), false);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return BitSets.toString(this);
    }

    static {
        for (int i2 = 0; i2 < STATIC_INSTANCES.length; ++i2) {
            TBitSet.STATIC_INSTANCES[i2] = new TBitSet(new long[]{i2});
        }
    }
}

