/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.enterprise;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.runtime.EngineCacheSupport;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionKey;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionValues;

public abstract class AbstractEngineCacheSupport
implements EngineCacheSupport {
    protected static final String COMPILE_HELP = "Policy to use to to force compilation for executed call targets before persisting the engine. Possible values are:%n  - 'none':     No compilations will be persisted and existing compilations will be invalidated.%n  - 'compiled': No compilations will be forced but finished compilations will be persisted.%n  - 'hot':      (default) All started compilations will be completed and then persisted.%n  - 'aot':      All started and AOT compilable roots will be forced to compile and persisted.%n  - 'executed': All executed and all AOT compilable roots will be forced to compile.";
    protected static final String COMPILE_USAGE_SYNTAX = "none|compiled|hot|aot|executed";

    protected abstract OptionKey<Boolean> getTraceOption();

    protected final void trace(EngineData engineData, String string, Object ... objectArray) {
        if (engineData.getEngineOptions().get(this.getTraceOption()).booleanValue()) {
            engineData.getLogger("engine").info("[cache] " + String.format(string, objectArray));
        }
    }

    protected final void traceLoad(OptionValues optionValues, Function<String, TruffleLogger> function, String string, Object ... objectArray) {
        if (optionValues.get(this.getTraceOption()).booleanValue()) {
            function.apply("engine").info("[cache] " + String.format(string, objectArray));
        }
    }

    protected final Object prepareEngine(EngineData engineData, CompilePolicy compilePolicy, boolean bl, boolean bl2) {
        Collection<OptimizedCallTarget> collection = engineData.getCallTargets();
        for (OptimizedCallTarget optimizedCallTarget : collection) {
            if (optimizedCallTarget.engine == engineData) continue;
            throw new IllegalStateException("CallTargets from different engines cannot be compiled together.");
        }
        List<OptimizedCallTarget> list = this.prepareTargetsForCompilation(engineData, collection, compilePolicy);
        if (bl2) {
            engineData.preinitializeContext();
        }
        engineData.finalizeStore();
        if (list != null && !list.isEmpty()) {
            this.compileTargets(engineData, (Collection<OptimizedCallTarget>)list, bl);
        }
        return engineData.getPolyglotEngine();
    }

    private void compileTargets(EngineData engineData, Collection<OptimizedCallTarget> collection, boolean bl) {
        this.trace(engineData, "Force compiling %s roots for engine caching.", collection.size());
        ArrayList<OptimizedCallTarget> arrayList = new ArrayList<OptimizedCallTarget>();
        for (OptimizedCallTarget optimizedCallTarget : collection) {
            if (optimizedCallTarget.isValid()) continue;
            if (!optimizedCallTarget.isInitialized()) {
                throw new AssertionError((Object)"Should not reach here.");
            }
            boolean bl2 = optimizedCallTarget.compile(bl);
            if (bl2) continue;
            arrayList.add(optimizedCallTarget);
        }
        for (OptimizedCallTarget optimizedCallTarget : arrayList) {
            try {
                OptimizedTruffleRuntime.getRuntime().waitForCompilation(optimizedCallTarget, Long.MAX_VALUE);
            }
            catch (CancellationException cancellationException) {
                break;
            }
            catch (ExecutionException | TimeoutException exception) {
                throw new AssertionError((Object)exception);
            }
        }
    }

    private List<OptimizedCallTarget> prepareTargetsForCompilation(EngineData engineData, Collection<OptimizedCallTarget> collection, CompilePolicy compilePolicy) throws AssertionError {
        List<OptimizedCallTarget> list;
        this.trace(engineData, "Force compile targets mode: %s", new Object[]{compilePolicy});
        switch (compilePolicy.ordinal()) {
            case 4: {
                this.cancelCompilations(engineData, collection);
                this.invalidateCompilations(engineData, collection);
                list = null;
                break;
            }
            case 3: {
                this.cancelCompilations(engineData, collection);
                list = null;
                break;
            }
            case 2: {
                AbstractEngineCacheSupport.waitForCompilations(collection);
                list = AbstractEngineCacheSupport.initializeCompileQueue(collection);
                list.removeIf(optimizedCallTarget -> !optimizedCallTarget.isInitialized() || !optimizedCallTarget.shouldCompile());
                break;
            }
            case 1: {
                AbstractEngineCacheSupport.waitForCompilations(collection);
                list = AbstractEngineCacheSupport.initializeCompileQueue(collection);
                list.removeIf(optimizedCallTarget -> optimizedCallTarget.isInitialized() && !optimizedCallTarget.shouldCompile());
                AbstractEngineCacheSupport.prepareForAOT(engineData, list, true);
                break;
            }
            case 0: {
                AbstractEngineCacheSupport.waitForCompilations(collection);
                list = AbstractEngineCacheSupport.initializeCompileQueue(collection);
                AbstractEngineCacheSupport.prepareForAOT(engineData, list, false);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid compile mode.");
            }
        }
        return list;
    }

    private static List<OptimizedCallTarget> initializeCompileQueue(Collection<OptimizedCallTarget> collection) {
        AbstractEngineCacheSupport.resetSplitting(collection);
        return AbstractEngineCacheSupport.sortCallTargetsByHotness(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepareForAOT(EngineData engineData, List<OptimizedCallTarget> list, boolean bl) {
        TruffleLanguage<?> truffleLanguage = null;
        Object object = null;
        try {
            ListIterator<OptimizedCallTarget> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                OptimizedCallTarget optimizedCallTarget = listIterator.next();
                if (!optimizedCallTarget.wasExecuted()) {
                    TruffleLanguage<?> truffleLanguage2 = engineData.getLanguage(optimizedCallTarget);
                    if (truffleLanguage2 != truffleLanguage) {
                        if (truffleLanguage != null) {
                            engineData.leaveLanguage(truffleLanguage, object);
                        }
                        if (truffleLanguage2 != null) {
                            object = engineData.enterLanguage(truffleLanguage2);
                        }
                        truffleLanguage = truffleLanguage2;
                    }
                    if (optimizedCallTarget.prepareForAOT()) continue;
                    listIterator.remove();
                    continue;
                }
                if (!bl) continue;
                listIterator.remove();
            }
        }
        finally {
            if (truffleLanguage != null) {
                engineData.leaveLanguage(truffleLanguage, object);
            }
        }
    }

    private void cancelCompilations(EngineData engineData, Collection<OptimizedCallTarget> collection) {
        int n2 = 0;
        for (OptimizedCallTarget optimizedCallTarget : collection) {
            if (!optimizedCallTarget.cancelCompilation("Engine cache compile mode none cancels all compiles if they are not yet completed.")) continue;
            ++n2;
        }
        if (n2 > 0) {
            this.trace(engineData, "Cancelled %s compilations.", n2);
            AbstractEngineCacheSupport.waitForCompilations(collection);
        }
    }

    private void invalidateCompilations(EngineData engineData, Collection<OptimizedCallTarget> collection) {
        int n2 = 0;
        for (OptimizedCallTarget optimizedCallTarget : collection) {
            if (optimizedCallTarget.isSubmittedForCompilation()) {
                throw new IllegalStateException("A call target that will be persisted is currently compiling.");
            }
            if (!optimizedCallTarget.invalidate("CacheCompile mode is none")) continue;
            ++n2;
        }
        if (n2 > 0) {
            AbstractEngineCacheSupport.waitForCompilations(collection);
            this.trace(engineData, "%s compilations invalidated.", n2);
        }
    }

    private static void waitForCompilations(Collection<OptimizedCallTarget> collection) {
        OptimizedTruffleRuntime optimizedTruffleRuntime = OptimizedTruffleRuntime.getRuntime();
        for (OptimizedCallTarget optimizedCallTarget : collection) {
            try {
                optimizedTruffleRuntime.waitForCompilation(optimizedCallTarget, Long.MAX_VALUE);
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException | TimeoutException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private static void resetSplitting(Collection<OptimizedCallTarget> collection) {
        for (OptimizedCallTarget optimizedCallTarget : collection) {
            optimizedCallTarget.resetNeedsSplit();
        }
    }

    private static List<OptimizedCallTarget> sortCallTargetsByHotness(Collection<OptimizedCallTarget> collection) {
        OptimizedCallTarget[] optimizedCallTargetArray = collection.toArray(new OptimizedCallTarget[0]);
        Arrays.sort(optimizedCallTargetArray, new Comparator<OptimizedCallTarget>(){

            @Override
            public int compare(OptimizedCallTarget optimizedCallTarget, OptimizedCallTarget optimizedCallTarget2) {
                int n2 = optimizedCallTarget.getCallAndLoopCount();
                int n3 = optimizedCallTarget2.getCallAndLoopCount();
                return Integer.compare(n3, n2);
            }
        });
        return new LinkedList<OptimizedCallTarget>(Arrays.asList(optimizedCallTargetArray));
    }

    public static enum CompilePolicy {
        executed,
        aot,
        hot,
        compiled,
        none;

    }
}

