/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.enterprise;

import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.enterprise.AbstractEngineCacheSupport;
import com.oracle.truffle.runtime.enterprise.DebugEngineCacheSupportOptionDescriptors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionDescriptors;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionKey;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionValues;

public final class DebugEngineCacheSupport
extends AbstractEngineCacheSupport {
    private static final AtomicReference<Object> persistedEngine = new AtomicReference();
    public static final OptionKey<Boolean> DebugTraceCache = new OptionKey<Boolean>(Boolean.FALSE);
    public static final OptionKey<Boolean> DebugCacheStore = new OptionKey<Boolean>(Boolean.FALSE);
    public static final OptionKey<Boolean> DebugCacheLoad = new OptionKey<Boolean>(Boolean.FALSE);
    public static final OptionKey<AbstractEngineCacheSupport.CompilePolicy> DebugCacheCompile = new OptionKey<AbstractEngineCacheSupport.CompilePolicy>(AbstractEngineCacheSupport.CompilePolicy.hot);
    public static final OptionKey<Boolean> DebugCachePreinitializeContext = new OptionKey<Boolean>(Boolean.TRUE);
    public static final OptionKey<Boolean> DebugCacheCompileUseLastTier = new OptionKey<Boolean>(Boolean.TRUE);

    @Override
    public OptionDescriptors getEngineOptions() {
        return new DebugEngineCacheSupportOptionDescriptors();
    }

    @Override
    public boolean isStoreEnabled(OptionValues optionValues) {
        return optionValues.get(DebugCacheStore);
    }

    @Override
    protected OptionKey<Boolean> getTraceOption() {
        return DebugTraceCache;
    }

    @Override
    public void onEngineCreated(EngineData engineData) {
    }

    @Override
    public void onEnginePatch(EngineData engineData) {
    }

    @Override
    public Object tryLoadingCachedEngine(OptionValues optionValues, Function<String, TruffleLogger> function) {
        if (!optionValues.get(DebugCacheLoad).booleanValue()) {
            this.traceLoad(optionValues, function, "--engine.DebugCacheLoad is not enabled. Not loading engine.", new Object[0]);
            return null;
        }
        Object var3_3 = persistedEngine.getAndSet(null);
        if (var3_3 == null) {
            this.traceLoad(optionValues, function, "No cached debug engine to load in memory found.", new Object[0]);
            return null;
        }
        this.traceLoad(optionValues, function, "Loaded debug engine from in memory cache.", new Object[0]);
        return var3_3;
    }

    @Override
    public boolean onEngineClosing(EngineData engineData) {
        OptionValues optionValues = engineData.getEngineOptions();
        if (!optionValues.get(DebugCacheStore).booleanValue()) {
            return false;
        }
        this.trace(engineData, "Preparing debug engine for storage...", new Object[0]);
        AbstractEngineCacheSupport.CompilePolicy compilePolicy = optionValues.get(DebugCacheCompile);
        persistedEngine.set(this.prepareEngine(engineData, compilePolicy, optionValues.get(DebugCacheCompileUseLastTier), optionValues.get(DebugCachePreinitializeContext)));
        this.trace(engineData, "Stored debug engine in memory.", new Object[0]);
        return true;
    }

    @Override
    public void onEngineClosed(EngineData engineData) {
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

