/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.hotspot.libgraal;

import com.oracle.truffle.runtime.hotspot.libgraal.DestroyedIsolateException;
import com.oracle.truffle.runtime.hotspot.libgraal.LibGraal;
import com.oracle.truffle.runtime.hotspot.libgraal.LibGraalIsolate;
import com.oracle.truffle.runtime.hotspot.libgraal.LibGraalScope;

public class LibGraalObject {
    private static volatile boolean exiting;
    private final long handle;
    private final LibGraalIsolate isolate;

    protected LibGraalObject(long handle) {
        this.handle = handle;
        this.isolate = LibGraalScope.current().getIsolate();
        this.isolate.register(this, handle);
    }

    public long getHandle() {
        if (!this.isolate.isValid()) {
            throw new DestroyedIsolateException(this.toString(), exiting);
        }
        return this.handle;
    }

    static native boolean releaseHandle(long var0, long var2);

    public String toString() {
        Object name = this.getClass().getSimpleName();
        for (Class<?> outer = this.getClass().getDeclaringClass(); outer != null; outer = outer.getDeclaringClass()) {
            name = outer.getSimpleName() + "." + (String)name;
        }
        return String.format("%s[%d]", name, this.handle);
    }

    static {
        if (LibGraal.isAvailable()) {
            LibGraal.registerNativeMethods(LibGraalObject.class);
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        exiting = true;
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

