/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.evaluate.translation.translator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integratedscripting.api.evaluate.translation.IEvaluationExceptionFactory;
import org.cyclops.integratedscripting.api.evaluate.translation.IValueTranslator;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;

public class ValueTranslatorList
implements IValueTranslator<ValueTypeList.ValueList> {
    @Override
    public IValueType<?> getValueType() {
        return ValueTypes.LIST;
    }

    @Override
    public boolean canHandleGraalValue(Value value) {
        return value.hasArrayElements();
    }

    @Override
    public boolean canTranslateNbt() {
        return true;
    }

    @Override
    public Value translateToGraal(Context context, ValueTypeList.ValueList value, IEvaluationExceptionFactory exceptionFactory, ValueDeseralizationContext valueDeseralizationContext) throws EvaluationException {
        if (value.getRawValue().isInfinite()) {
            throw exceptionFactory.createError(Component.translatable((String)"valuetype.integratedscripting.error.translation.list_infinite"));
        }
        ArrayList<Value> list = new ArrayList<Value>();
        for (IValue innerValue : value.getRawValue()) {
            Value translate = ValueTranslators.REGISTRY.translateToGraal(context, innerValue, exceptionFactory, valueDeseralizationContext);
            list.add(translate);
        }
        return context.asValue(list);
    }

    @Override
    public ValueTypeList.ValueList translateFromGraal(Context context, Value value, IEvaluationExceptionFactory exceptionFactory, ValueDeseralizationContext valueDeseralizationContext) throws EvaluationException {
        ArrayList values = Lists.newArrayList();
        long length = value.getArraySize();
        for (long i2 = 0L; i2 < length; ++i2) {
            values.add(ValueTranslators.REGISTRY.translateFromGraal(context, value.getArrayElement(i2), exceptionFactory, valueDeseralizationContext));
        }
        return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.CATEGORY_ANY, (List)values);
    }

    @Override
    public Tag translateToNbt(Context context, ValueTypeList.ValueList value, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        if (value.getRawValue().isInfinite()) {
            throw exceptionFactory.createError(Component.translatable((String)"valuetype.integratedscripting.error.translation.list_infinite"));
        }
        ListTag tag = new ListTag();
        for (IValue subValue : value.getRawValue()) {
            tag.add((Object)ValueTranslators.REGISTRY.translateToNbt(context, subValue, exceptionFactory));
        }
        return tag;
    }
}

