/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIExceptionWrapper;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.WordFactory;

public final class JNIClassCache {
    private static final Map<String, JNIClassData> classesByName = new ConcurrentHashMap<String, JNIClassData>();

    private JNIClassCache() {
    }

    public static JNI.JClass lookupClass(JNI.JNIEnv env, Class<?> clazz) throws JNIExceptionWrapper {
        return JNIClassCache.lookupClass(env, clazz.getName());
    }

    public static JNI.JClass lookupClass(JNI.JNIEnv env, String className) throws JNIExceptionWrapper {
        return JNIClassCache.lookupClassImpl(env, className, true);
    }

    private static JNI.JClass lookupClassImpl(final JNI.JNIEnv env, final String className, final boolean required) {
        Function<String, JNIClassData> createClassData = new Function<String, JNIClassData>(){

            @Override
            public JNIClassData apply(String cn) {
                JNI.JClass jClass = JNIUtil.findClass(env, (JNI.JObject)WordFactory.nullPointer(), JNIUtil.getBinaryName(className), required);
                if (jClass.isNull()) {
                    return JNIClassData.INVALID;
                }
                return new JNIClassData(JNIUtil.NewGlobalRef(env, jClass, "Class<" + className + ">"));
            }
        };
        return JNIClassCache.classesByName.computeIfAbsent((String)className, (Function<String, JNIClassData>)createClassData).jClassGlobal;
    }

    public static void dispose(JNI.JNIEnv jniEnv) {
        Iterator<JNIClassData> iterator = classesByName.values().iterator();
        while (iterator.hasNext()) {
            JNIClassData classData = iterator.next();
            iterator.remove();
            if (classData == JNIClassData.INVALID) continue;
            JNIUtil.DeleteGlobalRef(jniEnv, classData.jClassGlobal);
        }
    }

    private static final class JNIClassData {
        static final JNIClassData INVALID = new JNIClassData(null);
        private final JNI.JClass jClassGlobal;

        JNIClassData(JNI.JClass jClassGlobal) {
            this.jClassGlobal = jClassGlobal;
        }
    }
}

