/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.template;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.core.render.RenderWorldEvent;
import com.supermartijn642.formations.tools.template.Template;
import com.supermartijn642.formations.tools.template.TemplateEditorItem;
import com.supermartijn642.formations.tools.template.TemplateManager;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class TemplateRenderer {
    public static ResourceKey<Level> selectionDimension;
    public static BlockPos selectionPos1;
    public static BlockPos selectionPos2;

    public static void registerListeners() {
        NeoForge.EVENT_BUS.addListener(TemplateRenderer::renderTemplates);
    }

    public static Template getAimedAtTemplate() {
        HitResult hitResult = ClientUtils.getMinecraft().hitResult;
        if (hitResult != null && hitResult.getType() != HitResult.Type.MISS) {
            return null;
        }
        Vec3 playerPos = ClientUtils.getMinecraft().gameRenderer.getMainCamera().getPosition();
        Vec3 playerFacingPos = new Vec3(ClientUtils.getMinecraft().gameRenderer.getMainCamera().getPosition().toVector3f().add((Vector3fc)ClientUtils.getMinecraft().gameRenderer.getMainCamera().getLookVector().mul(100.0f)));
        Template aimedTemplate = null;
        double distance = 0.0;
        for (Template template : TemplateManager.get(ClientUtils.getWorld()).getAllTemplates()) {
            Optional<Double> d = template.getArea().clip(playerPos, playerFacingPos).map(arg_0 -> ((Vec3)playerPos).distanceToSqr(arg_0));
            if (!d.isPresent() || aimedTemplate != null && !(d.get() < distance)) continue;
            aimedTemplate = template;
            distance = d.get();
        }
        return aimedTemplate;
    }

    private static void renderTemplates(RenderWorldEvent e) {
        e.getPoseStack().pushPose();
        Vec3 camera = RenderUtils.getCameraPosition();
        e.getPoseStack().translate(-camera.x, -camera.y, -camera.z);
        TemplateManager.get(ClientUtils.getWorld()).getAllTemplates().stream().filter(template -> template.getArea().distanceToSqr(ClientUtils.getPlayer().position()) < 40000.0).forEach(template -> {
            RenderUtils.renderBox((PoseStack)e.getPoseStack(), (AABB)template.getArea().inflate(0.1), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f, (boolean)true);
            RenderUtils.renderBoxSides((PoseStack)e.getPoseStack(), (AABB)template.getArea().inflate(0.1), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f, (boolean)true);
            TemplateRenderer.renderTemplateText(e.getPoseStack(), template);
        });
        if (!(ClientUtils.getPlayer().getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof TemplateEditorItem)) {
            e.getPoseStack().popPose();
            return;
        }
        if (ClientUtils.getWorld().dimension() == selectionDimension && selectionPos1 != null && selectionPos2 != null) {
            AABB box = new AABB(selectionPos1).minmax(new AABB(selectionPos2)).inflate(0.1);
            RenderUtils.renderBox((PoseStack)e.getPoseStack(), (AABB)box, (float)1.0f, (float)1.0f, (float)0.5f, (float)1.0f, (boolean)false);
            RenderUtils.renderBoxSides((PoseStack)e.getPoseStack(), (AABB)box, (float)1.0f, (float)1.0f, (float)0.5f, (float)0.1f, (boolean)false);
            RenderUtils.renderBoxSides((PoseStack)e.getPoseStack(), (AABB)box, (float)1.0f, (float)1.0f, (float)0.5f, (float)0.3f, (boolean)true);
        } else {
            Template aimedTemplate;
            if (ClientUtils.getWorld().dimension() == selectionDimension && (selectionPos1 != null || selectionPos2 != null)) {
                RenderUtils.renderBox((PoseStack)e.getPoseStack(), (AABB)new AABB(selectionPos1 == null ? selectionPos2 : selectionPos1), (float)1.0f, (float)1.0f, (float)0.5f, (float)1.0f, (boolean)false);
            }
            if ((aimedTemplate = TemplateRenderer.getAimedAtTemplate()) != null) {
                RenderUtils.renderBox((PoseStack)e.getPoseStack(), (AABB)aimedTemplate.getArea().inflate(0.1), (float)1.0f, (float)1.0f, (float)0.5f, (float)1.0f, (boolean)false);
                RenderUtils.renderBoxSides((PoseStack)e.getPoseStack(), (AABB)aimedTemplate.getArea().inflate(0.1), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f, (boolean)false);
            }
        }
        e.getPoseStack().popPose();
    }

    private static void renderTemplateText(PoseStack poseStack, Template template) {
        AABB area = template.getArea();
        Font renderer = ClientUtils.getFontRenderer();
        int nameWidth = renderer.width(template.getName());
        Vec3 center = area.getCenter();
        float f = ((float)area.getXsize() + 1.0f) / (float)nameWidth;
        float f2 = (float)area.getYsize() + 1.0f;
        Objects.requireNonNull(renderer);
        float xScaling = -Math.min(f, f2 / 9.0f) * 0.8f;
        float f3 = ((float)area.getZsize() + 1.0f) / (float)nameWidth;
        float f4 = (float)area.getYsize() + 1.0f;
        Objects.requireNonNull(renderer);
        float zScaling = -Math.min(f3, f4 / 9.0f) * 0.8f;
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        poseStack.pushPose();
        poseStack.translate(center.x, center.y, area.minZ - 0.1);
        poseStack.scale(xScaling, xScaling, 1.0f);
        String string = template.getName();
        float f5 = (float)(-nameWidth) / 2.0f;
        Objects.requireNonNull(renderer);
        renderer.drawInBatch(string, f5, (float)(-9) / 2.0f, -922746881, false, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(center.x, center.y, area.maxZ + 0.1);
        poseStack.scale(-xScaling, xScaling, 1.0f);
        String string2 = template.getName();
        float f6 = (float)(-nameWidth) / 2.0f;
        Objects.requireNonNull(renderer);
        renderer.drawInBatch(string2, f6, (float)(-9) / 2.0f, -922746881, false, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(area.minX - 0.1, center.y, center.z);
        poseStack.scale(1.0f, zScaling, zScaling);
        poseStack.mulPose((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, 0.0f, 1.0f, 0.0f));
        String string3 = template.getName();
        float f7 = (float)(-nameWidth) / 2.0f;
        Objects.requireNonNull(renderer);
        renderer.drawInBatch(string3, f7, (float)(-9) / 2.0f, -922746881, false, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(area.maxX + 0.1, center.y, center.z);
        poseStack.scale(1.0f, zScaling, -zScaling);
        poseStack.mulPose((Quaternionfc)new Quaternionf().rotateAxis(1.5707964f, 0.0f, 1.0f, 0.0f));
        String string4 = template.getName();
        float f8 = (float)(-nameWidth) / 2.0f;
        Objects.requireNonNull(renderer);
        renderer.drawInBatch(string4, f8, (float)(-9) / 2.0f, -922746881, false, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.popPose();
    }
}

