/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects;

import com.mcwbridges.kikoz.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Bridge_Block
extends Block {
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.create((String)"connection", ConnectionStatus.class);
    protected static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)4.0, (double)15.99);
    protected static final VoxelShape SIDE_0 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape SIDE_90 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0));
    protected static final VoxelShape SIDE_180 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0));
    protected static final VoxelShape SIDE_270 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape CORNER_0 = Shapes.or((VoxelShape)SIDE_180, (VoxelShape)SIDE_90);
    protected static final VoxelShape CORNER_90 = Shapes.or((VoxelShape)SIDE_180, (VoxelShape)SIDE_270);
    protected static final VoxelShape CORNER_180 = Shapes.or((VoxelShape)SIDE_270, (VoxelShape)SIDE_0);
    protected static final VoxelShape CORNER_270 = Shapes.or((VoxelShape)SIDE_0, (VoxelShape)SIDE_90);
    protected static final VoxelShape MIDDLE_90 = Shapes.or((VoxelShape)SIDE_0, (VoxelShape)SIDE_180);
    protected static final VoxelShape MIDDLE_0 = Shapes.or((VoxelShape)SIDE_90, (VoxelShape)SIDE_270);
    protected static final VoxelShape BASE_COLLISION = Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)3.0, (double)15.99);
    protected static final VoxelShape COLLISION_SIDE_0 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_SIDE_90 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_SIDE_180 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)25.0, (double)1.0));
    protected static final VoxelShape COLLISION_SIDE_270 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_CORNER_0 = Shapes.or((VoxelShape)COLLISION_SIDE_180, (VoxelShape)COLLISION_SIDE_90);
    protected static final VoxelShape COLLISION_CORNER_90 = Shapes.or((VoxelShape)COLLISION_SIDE_180, (VoxelShape)COLLISION_SIDE_270);
    protected static final VoxelShape COLLISION_CORNER_180 = Shapes.or((VoxelShape)COLLISION_SIDE_270, (VoxelShape)COLLISION_SIDE_0);
    protected static final VoxelShape COLLISION_CORNER_270 = Shapes.or((VoxelShape)COLLISION_SIDE_0, (VoxelShape)COLLISION_SIDE_90);
    protected static final VoxelShape COLLISION_MIDDLE_90 = Shapes.or((VoxelShape)COLLISION_SIDE_0, (VoxelShape)COLLISION_SIDE_180);
    protected static final VoxelShape COLLISION_MIDDLE_0 = Shapes.or((VoxelShape)COLLISION_SIDE_90, (VoxelShape)COLLISION_SIDE_270);
    private boolean wasInteractedWith = false;

    public Bridge_Block(BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(CONNECTION, (Comparable)((Object)ConnectionStatus.BASE)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        switch (((ConnectionStatus)((Object)state.getValue(CONNECTION))).ordinal()) {
            case 0: {
                return BASE;
            }
            case 3: {
                return CORNER_270;
            }
            case 4: {
                return CORNER_180;
            }
            case 5: {
                return CORNER_0;
            }
            case 6: {
                return CORNER_90;
            }
            case 2: {
                return MIDDLE_0;
            }
            case 1: {
                return MIDDLE_90;
            }
            case 8: {
                return SIDE_270;
            }
            case 7: {
                return SIDE_180;
            }
            case 9: {
                return SIDE_0;
            }
            case 10: {
                return SIDE_90;
            }
        }
        return BASE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        switch (((ConnectionStatus)((Object)state.getValue(CONNECTION))).ordinal()) {
            case 0: {
                return BASE;
            }
            case 3: {
                return COLLISION_CORNER_270;
            }
            case 4: {
                return COLLISION_CORNER_180;
            }
            case 5: {
                return COLLISION_CORNER_0;
            }
            case 6: {
                return COLLISION_CORNER_90;
            }
            case 2: {
                return COLLISION_MIDDLE_0;
            }
            case 1: {
                return COLLISION_MIDDLE_90;
            }
            case 8: {
                return COLLISION_SIDE_270;
            }
            case 7: {
                return COLLISION_SIDE_180;
            }
            case 9: {
                return COLLISION_SIDE_0;
            }
            case 10: {
                return COLLISION_SIDE_90;
            }
        }
        return BASE_COLLISION;
    }

    private BlockState StairState(BlockState state, LevelReader access, BlockPos pos) {
        boolean north = access.getBlockState(pos.north()).getBlock() == this;
        boolean east = access.getBlockState(pos.east()).getBlock() == this;
        boolean south = access.getBlockState(pos.south()).getBlock() == this;
        boolean west = access.getBlockState(pos.west()).getBlock() == this;
        ConnectionStatus connection = this.getConnectionStatus(north, east, south, west);
        return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)connection));
    }

    private ConnectionStatus getConnectionStatus(boolean north, boolean east, boolean south, boolean west) {
        if (!(north || south || east || west)) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (north && !east && south && !west) {
            return ConnectionStatus.MIDDLE_EW;
        }
        if (!north && east && !south && west) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (!north && !east && south && !west) {
            return ConnectionStatus.MIDDLE_EW;
        }
        if (north && !east && !south && !west) {
            return ConnectionStatus.MIDDLE_EW;
        }
        if (!north && !east && !south && west) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (!north && east && !south && !west) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (!north && !east && south && west) {
            return ConnectionStatus.CORNER_SW;
        }
        if (!north && east && south && !west) {
            return ConnectionStatus.CORNER_SE;
        }
        if (north && !east && !south && west) {
            return ConnectionStatus.CORNER_NW;
        }
        if (north && east && !south && !west) {
            return ConnectionStatus.CORNER_NE;
        }
        if (!north && east && south && west) {
            return ConnectionStatus.SIDE_N;
        }
        if (north && !east && south && west) {
            return ConnectionStatus.SIDE_E;
        }
        if (north && east && !south && west) {
            return ConnectionStatus.SIDE_S;
        }
        if (north && east && south && !west) {
            return ConnectionStatus.SIDE_W;
        }
        return ConnectionStatus.BASE;
    }

    public InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Direction facing;
        BlockPos placePos;
        BlockItem blockItem;
        Item item = itemstack.getItem();
        if (item == ItemInit.PLIERS.get() || item == Items.SHEARS) {
            BlockState newState = (BlockState)state.cycle(CONNECTION);
            level.setBlockAndUpdate(pos, newState);
            this.setWasInteractedWith(true, level, pos);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.getItem() instanceof BlockItem && (blockItem = (BlockItem)itemstack.getItem()).getBlock() == this && level.getBlockState(placePos = pos.relative(facing = player.getDirection())).isAir()) {
            level.setBlock(placePos, this.defaultBlockState(), 3);
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            level.playSound(null, pos, SoundEvents.STONE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void setWasInteractedWith(boolean interacted, Level level, BlockPos pos) {
        this.wasInteractedWith = interacted;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.is(state.getBlock())) {
            level.setBlock(pos, this.StairState(state, (LevelReader)level, pos), 2);
            this.wasInteractedWith = false;
        }
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess ticker, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (this.wasInteractedWith) {
            return state;
        }
        return this.StairState(state, level, currentPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CONNECTION});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext contx) {
        BlockPos pos = contx.getClickedPos().below();
        Level world = contx.getLevel();
        BlockState stateBelow = world.getBlockState(pos);
        if (stateBelow.getBlock() instanceof Bridge_Block) {
            return null;
        }
        return this.StairState(super.getStateForPlacement(contx), (LevelReader)world, contx.getClickedPos());
    }

    public static enum ConnectionStatus implements StringRepresentable
    {
        BASE("base"),
        MIDDLE_NS("middle_ns"),
        MIDDLE_EW("middle_ew"),
        CORNER_NE("corner_ne"),
        CORNER_NW("corner_nw"),
        CORNER_SE("corner_se"),
        CORNER_SW("corner_sw"),
        SIDE_N("side_n"),
        SIDE_E("side_e"),
        SIDE_S("side_s"),
        SIDE_W("side_w");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

