/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects;

import com.mcwbridges.kikoz.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Bridge_Block_Rope
extends Block {
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.create((String)"connection", ConnectionStatus.class);
    protected static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)4.0, (double)15.99);
    protected static final VoxelShape SIDE_0 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape SIDE_90 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0));
    protected static final VoxelShape SIDE_180 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0));
    protected static final VoxelShape SIDE_270 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape CORNER_0 = Shapes.or((VoxelShape)SIDE_180, (VoxelShape)SIDE_90);
    protected static final VoxelShape CORNER_90 = Shapes.or((VoxelShape)SIDE_180, (VoxelShape)SIDE_270);
    protected static final VoxelShape CORNER_180 = Shapes.or((VoxelShape)SIDE_270, (VoxelShape)SIDE_0);
    protected static final VoxelShape CORNER_270 = Shapes.or((VoxelShape)SIDE_0, (VoxelShape)SIDE_90);
    protected static final VoxelShape MIDDLE_90 = Shapes.or((VoxelShape)SIDE_0, (VoxelShape)SIDE_180);
    protected static final VoxelShape MIDDLE_0 = Shapes.or((VoxelShape)SIDE_90, (VoxelShape)SIDE_270);
    protected static final VoxelShape BASE_COLLISION = Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)3.0, (double)15.99);
    protected static final VoxelShape COLLISION_SIDE_0 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_SIDE_90 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_SIDE_180 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)25.0, (double)1.0));
    protected static final VoxelShape COLLISION_SIDE_270 = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_CORNER_0 = Shapes.or((VoxelShape)COLLISION_SIDE_180, (VoxelShape)COLLISION_SIDE_90);
    protected static final VoxelShape COLLISION_CORNER_90 = Shapes.or((VoxelShape)COLLISION_SIDE_180, (VoxelShape)COLLISION_SIDE_270);
    protected static final VoxelShape COLLISION_CORNER_180 = Shapes.or((VoxelShape)COLLISION_SIDE_270, (VoxelShape)COLLISION_SIDE_0);
    protected static final VoxelShape COLLISION_CORNER_270 = Shapes.or((VoxelShape)COLLISION_SIDE_0, (VoxelShape)COLLISION_SIDE_90);
    protected static final VoxelShape COLLISION_MIDDLE_90 = Shapes.or((VoxelShape)COLLISION_SIDE_0, (VoxelShape)COLLISION_SIDE_180);
    protected static final VoxelShape COLLISION_MIDDLE_0 = Shapes.or((VoxelShape)COLLISION_SIDE_90, (VoxelShape)COLLISION_SIDE_270);
    public static final EnumProperty<Direction> FACING_TD = EnumProperty.create((String)"facing", Direction.class, (Enum[])new Direction[]{Direction.NORTH, Direction.EAST});
    private boolean wasInteractedWith = false;

    public Bridge_Block_Rope(BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)this.stateDefinition.any());
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        switch (((ConnectionStatus)((Object)state.getValue(CONNECTION))).ordinal()) {
            case 0: {
                return BASE;
            }
            case 7: {
                return CORNER_270;
            }
            case 8: {
                return CORNER_180;
            }
            case 9: {
                return CORNER_0;
            }
            case 10: {
                return CORNER_90;
            }
            case 17: {
                return SIDE_90;
            }
            case 18: {
                return SIDE_90;
            }
            case 15: {
                return SIDE_270;
            }
            case 16: {
                return SIDE_270;
            }
            case 19: {
                return SIDE_0;
            }
            case 20: {
                return SIDE_180;
            }
            case 21: {
                return SIDE_180;
            }
            case 22: {
                return SIDE_0;
            }
            case 4: {
                return MIDDLE_90;
            }
            case 3: {
                return MIDDLE_0;
            }
            case 5: {
                return MIDDLE_0;
            }
            case 6: {
                return MIDDLE_90;
            }
            case 2: {
                return MIDDLE_0;
            }
            case 1: {
                return MIDDLE_90;
            }
            case 12: {
                return SIDE_270;
            }
            case 11: {
                return SIDE_180;
            }
            case 13: {
                return SIDE_0;
            }
            case 14: {
                return SIDE_90;
            }
            case 23: {
                return BASE;
            }
        }
        return BASE;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        Direction originalDirection = (Direction)state.getValue(FACING_TD);
        Direction rotatedDirection = rot.rotate(originalDirection);
        rotatedDirection = originalDirection == Direction.NORTH || originalDirection == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
        return (BlockState)state.setValue(FACING_TD, (Comparable)rotatedDirection);
    }

    public BlockState mirror(BlockState state, Mirror mir) {
        Direction originalDirection = (Direction)state.getValue(FACING_TD);
        Direction rotatedDirection = mir == Mirror.FRONT_BACK ? originalDirection : originalDirection.getOpposite();
        rotatedDirection = originalDirection == Direction.NORTH || originalDirection == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
        return (BlockState)state.setValue(FACING_TD, (Comparable)rotatedDirection);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        switch (((ConnectionStatus)((Object)state.getValue(CONNECTION))).ordinal()) {
            case 0: {
                return BASE;
            }
            case 7: {
                return COLLISION_CORNER_270;
            }
            case 8: {
                return COLLISION_CORNER_180;
            }
            case 9: {
                return COLLISION_CORNER_0;
            }
            case 10: {
                return COLLISION_CORNER_90;
            }
            case 17: {
                return COLLISION_SIDE_90;
            }
            case 18: {
                return COLLISION_SIDE_90;
            }
            case 15: {
                return COLLISION_SIDE_270;
            }
            case 16: {
                return COLLISION_SIDE_270;
            }
            case 19: {
                return COLLISION_SIDE_0;
            }
            case 20: {
                return COLLISION_SIDE_180;
            }
            case 21: {
                return COLLISION_SIDE_180;
            }
            case 22: {
                return COLLISION_SIDE_0;
            }
            case 4: {
                return COLLISION_MIDDLE_90;
            }
            case 3: {
                return COLLISION_MIDDLE_0;
            }
            case 5: {
                return COLLISION_MIDDLE_0;
            }
            case 6: {
                return COLLISION_MIDDLE_90;
            }
            case 2: {
                return COLLISION_MIDDLE_0;
            }
            case 1: {
                return COLLISION_MIDDLE_90;
            }
            case 12: {
                return COLLISION_SIDE_270;
            }
            case 11: {
                return COLLISION_SIDE_180;
            }
            case 13: {
                return COLLISION_SIDE_0;
            }
            case 14: {
                return COLLISION_SIDE_90;
            }
            case 23: {
                return BASE_COLLISION;
            }
        }
        return BASE_COLLISION;
    }

    private BlockState StairState(BlockState state, LevelReader access, BlockPos pos) {
        boolean north = access.getBlockState(pos.north()).getBlock() == this;
        boolean east = access.getBlockState(pos.east()).getBlock() == this;
        boolean south = access.getBlockState(pos.south()).getBlock() == this;
        boolean west = access.getBlockState(pos.west()).getBlock() == this;
        ConnectionStatus connection = this.getConnectionStatus(north, east, south, west);
        Direction facingDirection = (Direction)state.getValue(FACING_TD);
        return (BlockState)((BlockState)state.setValue(CONNECTION, (Comparable)((Object)connection))).setValue(FACING_TD, (Comparable)facingDirection);
    }

    private ConnectionStatus getConnectionStatus(boolean north, boolean east, boolean south, boolean west) {
        if (!(north || south || east || west)) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (north && !east && south && !west) {
            return ConnectionStatus.MIDDLE_EW;
        }
        if (!north && east && !south && west) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (!north && !east && south && !west) {
            return ConnectionStatus.MIDDLE_END_S;
        }
        if (north && !east && !south && !west) {
            return ConnectionStatus.MIDDLE_END_N;
        }
        if (!north && !east && !south && west) {
            return ConnectionStatus.MIDDLE_END_W;
        }
        if (!north && east && !south && !west) {
            return ConnectionStatus.MIDDLE_END_E;
        }
        if (!north && !east && south && west) {
            return ConnectionStatus.CORNER_SW;
        }
        if (!north && east && south && !west) {
            return ConnectionStatus.CORNER_SE;
        }
        if (north && !east && !south && west) {
            return ConnectionStatus.CORNER_NW;
        }
        if (north && east && !south && !west) {
            return ConnectionStatus.CORNER_NE;
        }
        if (!north && east && south && west) {
            return ConnectionStatus.SIDE_N;
        }
        if (north && !east && south && west) {
            return ConnectionStatus.SIDE_E;
        }
        if (north && east && !south && west) {
            return ConnectionStatus.SIDE_S;
        }
        if (north && east && south && !west) {
            return ConnectionStatus.SIDE_W;
        }
        return ConnectionStatus.BASE;
    }

    public InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockItem blockItem;
        Item item = itemstack.getItem();
        ConnectionStatus connection = (ConnectionStatus)((Object)state.getValue(CONNECTION));
        if (item == ItemInit.PLIERS.get() || item == Items.SHEARS) {
            ConnectionStatus newConnection = ConnectionStatus.BASE;
            switch (connection.ordinal()) {
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case 10: {
                    newConnection = ConnectionStatus.END_N_LEFT;
                    break;
                }
                case 15: {
                    newConnection = ConnectionStatus.END_S_RIGHT;
                    break;
                }
                case 20: {
                    newConnection = ConnectionStatus.CORNER_NW;
                    break;
                }
                case 8: {
                    newConnection = ConnectionStatus.END_S_LEFT;
                    break;
                }
                case 19: {
                    newConnection = ConnectionStatus.END_N_RIGHT;
                    break;
                }
                case 16: {
                    newConnection = ConnectionStatus.CORNER_NE;
                    break;
                }
                case 7: {
                    newConnection = ConnectionStatus.END_E_LEFT;
                    break;
                }
                case 17: {
                    newConnection = ConnectionStatus.END_W_RIGHT;
                    break;
                }
                case 22: {
                    newConnection = ConnectionStatus.CORNER_SE;
                    break;
                }
                case 9: {
                    newConnection = ConnectionStatus.END_W_LEFT;
                    break;
                }
                case 21: {
                    newConnection = ConnectionStatus.END_E_RIGHT;
                    break;
                }
                case 18: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case 23: {
                    newConnection = ConnectionStatus.CORNER_SW;
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(CONNECTION, (Comparable)((Object)newConnection)));
            this.setWasInteractedWith(true, level, pos);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.getItem() instanceof BlockItem && (blockItem = (BlockItem)itemstack.getItem()).getBlock() == this) {
            Direction facing = player.getDirection();
            Direction blockFacingDirection = facing == Direction.NORTH || facing == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
            BlockPos placePos = pos.relative(facing);
            if (level.getBlockState(placePos).isAir()) {
                level.setBlock(placePos, (BlockState)this.defaultBlockState().setValue(FACING_TD, (Comparable)blockFacingDirection), 3);
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                level.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void setWasInteractedWith(boolean interacted, Level level, BlockPos pos) {
        this.wasInteractedWith = interacted;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        this.wasInteractedWith = false;
        if (statetwo.hasProperty(FACING_TD) && statetwo.getBlock() instanceof Bridge_Block_Rope) {
            Direction facingDirection = (Direction)statetwo.getValue(FACING_TD);
            BlockState newState = (BlockState)state.setValue(FACING_TD, (Comparable)facingDirection);
            if (!statetwo.is(newState.getBlock())) {
                level.setBlock(pos, this.StairState(newState, (LevelReader)level, pos), 2);
            }
        } else {
            Direction currentFacing = (Direction)state.getValue(FACING_TD);
            BlockState defaultState = (BlockState)this.defaultBlockState().setValue(FACING_TD, (Comparable)currentFacing);
            level.setBlock(pos, this.StairState(defaultState, (LevelReader)level, pos), 2);
        }
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess ticker, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (this.wasInteractedWith) {
            return state;
        }
        ConnectionStatus connection = (ConnectionStatus)((Object)state.getValue(CONNECTION));
        if (connection == ConnectionStatus.BASE_TOGGLED || connection == ConnectionStatus.END_N_LEFT || connection == ConnectionStatus.END_N_RIGHT || connection == ConnectionStatus.END_E_LEFT || connection == ConnectionStatus.END_E_RIGHT || connection == ConnectionStatus.END_S_LEFT || connection == ConnectionStatus.END_S_RIGHT || connection == ConnectionStatus.END_W_LEFT || connection == ConnectionStatus.END_W_RIGHT) {
            return state;
        }
        return (BlockState)this.StairState(state, level, currentPos).setValue(FACING_TD, (Comparable)((Direction)state.getValue(FACING_TD)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CONNECTION, FACING_TD});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext contx) {
        Direction facingDirection = contx.getHorizontalDirection();
        if (facingDirection == Direction.WEST) {
            facingDirection = Direction.EAST;
        } else if (facingDirection == Direction.SOUTH) {
            facingDirection = Direction.NORTH;
        }
        BlockPos pos = contx.getClickedPos().below();
        Level world = contx.getLevel();
        BlockState stateBelow = world.getBlockState(pos);
        if (stateBelow.getBlock() instanceof Bridge_Block_Rope) {
            return null;
        }
        return (BlockState)this.StairState(super.getStateForPlacement(contx), (LevelReader)contx.getLevel(), contx.getClickedPos()).setValue(FACING_TD, (Comparable)facingDirection);
    }

    public static enum ConnectionStatus implements StringRepresentable
    {
        BASE("base"),
        MIDDLE_NS("middle_ns"),
        MIDDLE_EW("middle_ew"),
        MIDDLE_END_N("middle_end_n"),
        MIDDLE_END_E("middle_end_e"),
        MIDDLE_END_S("middle_end_s"),
        MIDDLE_END_W("middle_end_w"),
        CORNER_NE("corner_ne"),
        CORNER_NW("corner_nw"),
        CORNER_SE("corner_se"),
        CORNER_SW("corner_sw"),
        SIDE_N("side_n"),
        SIDE_E("side_e"),
        SIDE_S("side_s"),
        SIDE_W("side_w"),
        END_N_LEFT("end_n_left"),
        END_N_RIGHT("end_n_right"),
        END_E_LEFT("end_e_left"),
        END_E_RIGHT("end_e_right"),
        END_S_LEFT("end_s_left"),
        END_S_RIGHT("end_s_right"),
        END_W_LEFT("end_w_left"),
        END_W_RIGHT("end_w_right"),
        BASE_TOGGLED("base_toggled");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

