/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects.items;

import com.mcwbridges.kikoz.objects.Bridge_Block;
import com.mcwbridges.kikoz.objects.Bridge_Block_Rope;
import com.mcwbridges.kikoz.objects.Bridge_Stairs;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Bridge_Torch
extends HorizontalDirectionalBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<LightState> LIGHTSTATE = EnumProperty.create((String)"lightstate", LightState.class);
    protected static final VoxelShape EAST = Block.box((double)6.2, (double)0.0, (double)0.0, (double)9.8, (double)8.0, (double)2.8);
    protected static final VoxelShape SOUTH = Block.box((double)13.2, (double)0.0, (double)6.2, (double)16.0, (double)8.0, (double)9.8);
    protected static final VoxelShape WEST = Block.box((double)6.2, (double)0.0, (double)13.2, (double)9.8, (double)8.0, (double)16.0);
    protected static final VoxelShape NORTH = Block.box((double)0.0, (double)0.0, (double)6.2, (double)2.8, (double)8.0, (double)9.8);
    protected static final VoxelShape EAST_STAIR = Block.box((double)6.2, (double)6.0, (double)0.0, (double)9.8, (double)16.0, (double)2.8);
    protected static final VoxelShape SOUTH_STAIR = Block.box((double)13.2, (double)6.0, (double)6.2, (double)16.0, (double)16.0, (double)9.8);
    protected static final VoxelShape WEST_STAIR = Block.box((double)6.2, (double)6.0, (double)13.2, (double)9.8, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_STAIR = Block.box((double)0.0, (double)6.0, (double)6.2, (double)2.8, (double)16.0, (double)9.8);
    protected int lightValue;

    public Bridge_Torch(BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(LIGHTSTATE, (Comparable)((Object)LightState.BRIDGE)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        Direction facing = (Direction)state.getValue(FACING);
        LightState lightState = (LightState)((Object)state.getValue(LIGHTSTATE));
        if (lightState == LightState.BRIDGE) {
            switch (facing) {
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
            }
            return EAST;
        }
        switch (facing) {
            case NORTH: {
                return NORTH_STAIR;
            }
            case SOUTH: {
                return SOUTH_STAIR;
            }
            case WEST: {
                return WEST_STAIR;
            }
        }
        return EAST_STAIR;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        return Shapes.empty();
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, @Nullable Orientation fromPos, boolean bool) {
        if (pos.above().equals((Object)fromPos) && !level.getBlockState(pos.below()).isCollisionShapeFullBlock((BlockGetter)level, pos.below())) {
            level.destroyBlock(pos, true);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIGHTSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext contx) {
        BlockPos belowPos = contx.getClickedPos().below();
        BlockState belowState = contx.getLevel().getBlockState(belowPos);
        BlockState state = belowState.getBlock() instanceof Bridge_Block ? this.handleBridgeBlockPlacement(belowState) : (belowState.getBlock() instanceof Bridge_Block_Rope ? this.handleBridgeBlockRopePlacement(belowState) : (belowState.getBlock() instanceof Bridge_Stairs ? this.handleBridgeStairsPlacement(belowState) : (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)contx.getHorizontalDirection().getClockWise())));
        return state != null ? (BlockState)state.setValue(LIGHTSTATE, (Comparable)((Object)LightState.byState(belowState))) : null;
    }

    private BlockState handleBridgeBlockPlacement(BlockState belowState) {
        Bridge_Block.ConnectionStatus connectionStatus = (Bridge_Block.ConnectionStatus)((Object)belowState.getValue(Bridge_Block.CONNECTION));
        switch (connectionStatus) {
            case BASE: {
                return null;
            }
            case SIDE_E: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.SOUTH);
            }
            case SIDE_N: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.EAST);
            }
            case SIDE_S: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.WEST);
            }
            case SIDE_W: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH);
            }
            case MIDDLE_EW: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH);
            }
            case MIDDLE_NS: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.EAST);
            }
            case CORNER_NE: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH);
            }
            case CORNER_NW: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.WEST);
            }
            case CORNER_SE: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH);
            }
            case CORNER_SW: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.EAST);
            }
        }
        return this.defaultBlockState();
    }

    private BlockState handleBridgeBlockRopePlacement(BlockState belowState) {
        Bridge_Block_Rope.ConnectionStatus connectionStatus = (Bridge_Block_Rope.ConnectionStatus)((Object)belowState.getValue(Bridge_Block_Rope.CONNECTION));
        switch (connectionStatus) {
            case BASE: 
            case BASE_TOGGLED: {
                return null;
            }
            case SIDE_E: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.SOUTH);
            }
            case SIDE_N: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.EAST);
            }
            case SIDE_S: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.WEST);
            }
            case SIDE_W: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH);
            }
            case MIDDLE_EW: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH);
            }
            case MIDDLE_NS: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.EAST);
            }
            case CORNER_NE: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH);
            }
            case CORNER_NW: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.WEST);
            }
            case CORNER_SE: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH);
            }
            case CORNER_SW: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.EAST);
            }
            case MIDDLE_END_N: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH);
            }
            case MIDDLE_END_E: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.EAST);
            }
            case MIDDLE_END_S: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH);
            }
            case MIDDLE_END_W: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.EAST);
            }
            case END_E_LEFT: 
            case END_E_RIGHT: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH);
            }
            case END_N_LEFT: 
            case END_N_RIGHT: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.SOUTH);
            }
            case END_S_LEFT: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.WEST);
            }
            case END_S_RIGHT: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.EAST);
            }
            case END_W_LEFT: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.EAST);
            }
            case END_W_RIGHT: {
                return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.WEST);
            }
        }
        return this.defaultBlockState();
    }

    private BlockState handleBridgeStairsPlacement(BlockState belowState) {
        Bridge_Stairs.ConnectionStatus connectionStatus = (Bridge_Stairs.ConnectionStatus)((Object)belowState.getValue(Bridge_Stairs.CONNECTION));
        Direction stairsFacing = (Direction)belowState.getValue(Bridge_Stairs.FACING);
        if (connectionStatus == Bridge_Stairs.ConnectionStatus.DOUBLE) {
            return null;
        }
        Direction newFacing = connectionStatus == Bridge_Stairs.ConnectionStatus.LEFT ? this.rotateLeft(stairsFacing) : this.rotateRight(stairsFacing);
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)newFacing);
    }

    private Direction rotateLeft(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.SOUTH;
            }
        }
        return facing;
    }

    private Direction rotateRight(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
        }
        return facing;
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess ticker, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return facing == Direction.DOWN ? (BlockState)state.setValue(LIGHTSTATE, (Comparable)((Object)LightState.byState(facingState))) : super.updateShape(state, level, ticker, currentPos, facing, facingPos, facingState, random);
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        Direction facing = (Direction)stateIn.getValue(FACING);
        double d0 = (double)pos.getY() + 0.5;
        double d1 = (double)pos.getY() + 0.9;
        double southX = (double)pos.getX() + 0.5;
        double southZ = (double)pos.getZ() + 0.95;
        double northZ = (double)pos.getZ() + 0.05;
        double westX = (double)pos.getX() + 0.05;
        double westZ = (double)pos.getZ() + 0.5;
        double eastX = (double)pos.getX() + 0.95;
        double eastZ = (double)pos.getZ() + 0.5;
        LightState i = (LightState)((Object)stateIn.getValue(LIGHTSTATE));
        if (i == LightState.BRIDGE) {
            switch (facing) {
                case EAST: {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, southX, d0, northZ, 0.0, 0.0, 0.0);
                    worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, southX, d0, northZ, 0.0, 0.0, 0.0);
                    break;
                }
                case WEST: {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, southX, d0, southZ, 0.0, 0.0, 0.0);
                    worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, southX, d0, southZ, 0.0, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, westX, d0, westZ, 0.0, 0.0, 0.0);
                    worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, westX, d0, westZ, 0.0, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, eastX, d0, eastZ, 0.0, 0.0, 0.0);
                    worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, eastX, d0, eastZ, 0.0, 0.0, 0.0);
                }
            }
        } else {
            switch (facing) {
                case EAST: {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, southX, d1, northZ, 0.0, 0.0, 0.0);
                    worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, southX, d1, northZ, 0.0, 0.0, 0.0);
                    break;
                }
                case WEST: {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, southX, d1, southZ, 0.0, 0.0, 0.0);
                    worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, southX, d1, southZ, 0.0, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, westX, d1, westZ, 0.0, 0.0, 0.0);
                    worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, westX, d1, westZ, 0.0, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, eastX, d1, eastZ, 0.0, 0.0, 0.0);
                    worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, eastX, d1, eastZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static enum LightState implements StringRepresentable
    {
        BRIDGE("bridge"),
        STAIR("stair");

        private final String name;

        private LightState(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static LightState byState(BlockState state) {
            if (state.getBlock() instanceof Bridge_Stairs) {
                return STAIR;
            }
            return BRIDGE;
        }
    }
}

