/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.more_beautiful_torches.core.registry;

import com.cursee.matyrobbrt.registrationutils.RegistrationProvider;
import com.cursee.matyrobbrt.registrationutils.RegistryObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.function.Supplier;
import neoforge.com.cursee.more_beautiful_torches.Constants;
import neoforge.com.cursee.more_beautiful_torches.MoreBeautifulTorches;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ModBlocks {
    public static final LinkedList<RegistryObject<Block, Block>> REGISTERED = new LinkedList();
    public static final RegistrationProvider<Block> BLOCKS = RegistrationProvider.get((ResourceKey)Registries.BLOCK, (String)"more_beautiful_torches");

    public static RegistryObject<Block, Block> register(String name, Supplier<Block> supplier) {
        RegistryObject block = BLOCKS.register(name, supplier);
        REGISTERED.add((RegistryObject<Block, Block>)block);
        return block;
    }

    public static void declare() {
        ArrayList<String> lines = new ArrayList<String>();
        try (InputStream input = MoreBeautifulTorches.class.getResourceAsStream("/blocks.txt");){
            if (input == null) {
                throw new IOException("Failed to create InputStream from /blocks.txt");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                String line2;
                while ((line2 = reader.readLine()) != null) {
                    lines.add(line2);
                }
            }
        }
        catch (IOException e) {
            Constants.LOG.info("Failed to load a resource: {}", (Object)e.getMessage());
        }
        lines.forEach(line -> {
            String torch = line + "_torch";
            ResourceKey key1 = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreBeautifulTorches.identifier(torch));
            RegistryObject<Block, Block> block1 = ModBlocks.register(torch, () -> new TorchBlock(ParticleTypes.FLAME, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).setId(key1)));
            String wallTorch = line + "_wall_torch";
            ResourceKey key2 = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreBeautifulTorches.identifier(wallTorch));
            RegistryObject<Block, Block> block2 = ModBlocks.register(wallTorch, () -> new WallTorchBlock(ParticleTypes.FLAME, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WALL_TORCH).overrideLootTable(((Block)block1.get()).getLootTable()).overrideDescription(((Block)block1.get()).getDescriptionId()).setId(key2)));
            String redstoneTorch = line + "_redstone_torch";
            ResourceKey key3 = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreBeautifulTorches.identifier(redstoneTorch));
            RegistryObject<Block, Block> block3 = ModBlocks.register(redstoneTorch, () -> new RedstoneTorchBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_TORCH).setId(key3)));
            String redstoneWallTorch = line + "_redstone_wall_torch";
            ResourceKey key4 = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreBeautifulTorches.identifier(redstoneWallTorch));
            RegistryObject<Block, Block> block4 = ModBlocks.register(redstoneWallTorch, () -> new RedstoneWallTorchBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_WALL_TORCH).overrideLootTable(((Block)block3.get()).getLootTable()).overrideDescription(((Block)block3.get()).getDescriptionId()).setId(key4)));
            String soulTorch = line + "_soul_torch";
            ResourceKey key5 = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreBeautifulTorches.identifier(soulTorch));
            RegistryObject<Block, Block> block5 = ModBlocks.register(soulTorch, () -> new TorchBlock(ParticleTypes.SOUL_FIRE_FLAME, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_TORCH).setId(key5)));
            String soulWallTorch = line + "_soul_wall_torch";
            ResourceKey key6 = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)MoreBeautifulTorches.identifier(soulWallTorch));
            RegistryObject<Block, Block> block6 = ModBlocks.register(soulWallTorch, () -> new WallTorchBlock(ParticleTypes.SOUL_FIRE_FLAME, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_WALL_TORCH).overrideLootTable(((Block)block5.get()).getLootTable()).overrideDescription(((Block)block5.get()).getDescriptionId()).setId(key6)));
        });
    }
}

