/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectedWindow
extends Block {
    public static final EnumProperty<Direction> FACING = EnumProperty.create((String)"facing", Direction.class, (Enum[])new Direction[]{Direction.NORTH, Direction.EAST});
    public static final EnumProperty<ConnectionStatus> PART = EnumProperty.create((String)"part", ConnectionStatus.class);
    protected static final VoxelShape EE = ConnectedWindow.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NN = ConnectedWindow.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    private boolean wasInteractedWith = false;

    public ConnectedWindow(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)ConnectionStatus.BASE)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return ((Direction)state.getValue(FACING)).getAxis() == Direction.Axis.X ? NN : EE;
    }

    protected BlockState WindowState(BlockState state, LevelReader level, BlockPos pos) {
        boolean above = level.getBlockState(pos.above()).getBlock() == this;
        boolean below = level.getBlockState(pos.below()).getBlock() == this;
        boolean north = level.getBlockState(pos.north()).getBlock() == this;
        boolean east = level.getBlockState(pos.east()).getBlock() == this;
        boolean south = level.getBlockState(pos.south()).getBlock() == this;
        boolean west = level.getBlockState(pos.west()).getBlock() == this;
        switch ((Direction)state.getValue(FACING)) {
            case NORTH: {
                if (!above && below) {
                    if (east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.TOP_M));
                    }
                    if (!east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.TOP_L));
                    }
                    if (east && !west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.TOP_R));
                    }
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.TOP));
                }
                if (above && below) {
                    if (east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.MID_M));
                    }
                    if (!east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.MID_L));
                    }
                    if (east && !west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.MID_R));
                    }
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.MIDDLE));
                }
                if (above && !below) {
                    if (east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.BOT_M));
                    }
                    if (!east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.BOT_L));
                    }
                    if (east && !west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.BOT_R));
                    }
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.BOTTOM));
                }
                if (!above && !below) {
                    if (east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.SINGLE_M));
                    }
                    if (!east && west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.SINGLE_L));
                    }
                    if (east && !west) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.SINGLE_R));
                    }
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.BASE));
                }
            }
            case EAST: {
                if (!above && below) {
                    if (north && south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.TOP_M));
                    }
                    if (!north && south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.TOP_R));
                    }
                    if (north && !south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.TOP_L));
                    }
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.TOP));
                }
                if (above && below) {
                    if (north && south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.MID_M));
                    }
                    if (!north && south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.MID_R));
                    }
                    if (north && !south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.MID_L));
                    }
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.MIDDLE));
                }
                if (above && !below) {
                    if (north && south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.BOT_M));
                    }
                    if (!north && south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.BOT_R));
                    }
                    if (north && !south) {
                        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.BOT_L));
                    }
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.BOTTOM));
                }
                if (above || below) break;
                if (north && south) {
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.SINGLE_M));
                }
                if (!north && south) {
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.SINGLE_R));
                }
                if (north && !south) {
                    return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.SINGLE_L));
                }
                return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.BASE));
            }
        }
        return (BlockState)state.setValue(PART, (Comparable)((Object)ConnectionStatus.BASE));
    }

    public InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item item = itemstack.getItem();
        if (item == ItemInit.HAMMER.get() || item == Items.SHEARS) {
            BlockState newState = (BlockState)state.cycle(PART);
            worldIn.setBlockAndUpdate(pos, newState);
            this.setWasInteractedWith(true, worldIn, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void setWasInteractedWith(boolean interacted, Level level, BlockPos pos) {
        this.wasInteractedWith = interacted;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.is(state.getBlock())) {
            level.setBlock(pos, this.WindowState(state, (LevelReader)level, pos), 2);
            this.wasInteractedWith = false;
        }
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess ticker, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (this.wasInteractedWith) {
            return state;
        }
        return this.WindowState(state, level, currentPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext contx) {
        Direction facingDirection = contx.getHorizontalDirection();
        Level world = contx.getLevel();
        if (facingDirection == Direction.WEST) {
            facingDirection = Direction.EAST;
        } else if (facingDirection == Direction.SOUTH) {
            facingDirection = Direction.NORTH;
        }
        return (BlockState)this.WindowState(super.getStateForPlacement(contx), (LevelReader)world, contx.getClickedPos()).setValue(FACING, (Comparable)facingDirection);
    }

    public static enum ConnectionStatus implements StringRepresentable
    {
        BASE("base"),
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom"),
        TOP_L("top_l"),
        TOP_M("top_m"),
        TOP_R("top_r"),
        MID_L("mid_l"),
        MID_M("mid_m"),
        MID_R("mid_r"),
        BOT_L("bot_l"),
        BOT_M("bot_m"),
        BOT_R("bot_r"),
        SINGLE_L("single_l"),
        SINGLE_M("single_m"),
        SINGLE_R("single_r");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

