/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.fastmap;

import malte0811.ferritecore.fastmap.FastMapKey;
import net.minecraft.world.level.block.state.properties.Property;

public class CompactFastMapKey<T extends Comparable<T>>
extends FastMapKey<T> {
    private final int mapFactor;

    CompactFastMapKey(Property<T> property, int mapFactor) {
        super(property);
        this.mapFactor = mapFactor;
    }

    @Override
    public T getValue(int mapIndex) {
        int index = mapIndex / this.mapFactor % this.numValues();
        return this.byInternalIndex(index);
    }

    @Override
    public int replaceIn(int mapIndex, int newPartialIndex) {
        int lowerData = mapIndex % this.mapFactor;
        int upperFactor = this.mapFactor * this.numValues();
        int upperData = mapIndex - mapIndex % upperFactor;
        return lowerData + newPartialIndex + upperData;
    }

    @Override
    public int toPartialMapIndex(int internalIndex) {
        return this.mapFactor * internalIndex;
    }

    @Override
    public int getFactorToNext() {
        return this.numValues();
    }
}

