/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.api;

import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public interface Waystone {
    public UUID getWaystoneUid();

    public Component getName();

    public ResourceKey<Level> getDimension();

    default public boolean wasGenerated() {
        return this.getOrigin() == WaystoneOrigin.VILLAGE || this.getOrigin() == WaystoneOrigin.WILDERNESS || this.getOrigin() == WaystoneOrigin.DUNGEON;
    }

    public WaystoneOrigin getOrigin();

    public boolean isOwner(Player var1);

    public BlockPos getPos();

    public boolean isValid();

    public Optional<UUID> getOwnerUid();

    public ResourceLocation getWaystoneType();

    default public boolean hasName() {
        return !this.getName().getString().isEmpty();
    }

    default public boolean hasOwner() {
        return this.getOwnerUid().isPresent();
    }

    default public boolean isValidInLevel(ServerLevel level) {
        return false;
    }

    public boolean isTransient();

    public WaystoneVisibility getVisibility();
}

