/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.client.gui.widget.ITooltipProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class WaystoneVisbilityButton
extends Button
implements ITooltipProvider {
    private final WidgetSprites ACTIVATION_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"waystones/visibility_button_activation"), ResourceLocation.withDefaultNamespace((String)"waystones/visibility_button_activation_highlighted"));
    private final WidgetSprites GLOBAL_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"waystones/visibility_button_global"), ResourceLocation.withDefaultNamespace((String)"waystones/visibility_button_global_highlighted"));
    private final WidgetSprites SHARD_ONLY_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"waystones/visibility_button_shard_only"), ResourceLocation.withDefaultNamespace((String)"waystones/visibility_button_shard_only_highlighted"));
    private final WidgetSprites SHARESTONE_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"waystones/visibility_button_sharestone"), ResourceLocation.withDefaultNamespace((String)"waystones/visibility_button_sharestone_highlighted"));
    private final List<WaystoneVisibility> options;
    private final boolean canEdit;
    private WaystoneVisibility visibility;

    public WaystoneVisbilityButton(int x, int y, WaystoneVisibility visibility, List<WaystoneVisibility> options, boolean canEdit) {
        super(x, y, 18, 18, (Component)Component.empty(), button -> {}, Button.DEFAULT_NARRATION);
        this.options = options;
        this.visibility = visibility;
        this.canEdit = canEdit;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        ResourceLocation sprite = this.getSprites().get(this.isActive(), this.isHoveredOrFocused());
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, this.getX(), this.getY(), 20, 20);
    }

    @Override
    public boolean shouldShowTooltip() {
        return this.isHovered;
    }

    @Override
    public List<Component> getTooltipComponents() {
        MutableComponent visibilityValueComponent = Component.translatable((String)("tooltip.waystones.visibility." + this.visibility.name().toLowerCase(Locale.ROOT))).withStyle(ChatFormatting.WHITE);
        ArrayList<Component> result = new ArrayList<Component>();
        result.add((Component)Component.translatable((String)"tooltip.waystones.visibility", (Object[])new Object[]{visibilityValueComponent}).withStyle(ChatFormatting.YELLOW));
        if (!this.canEdit) {
            result.add((Component)Component.translatable((String)"tooltip.waystones.edit_restricted").withStyle(ChatFormatting.RED));
        }
        return result;
    }

    public WaystoneVisibility getVisibility() {
        return this.visibility;
    }

    private WidgetSprites getSprites() {
        return switch (this.visibility) {
            default -> throw new MatchException(null, null);
            case WaystoneVisibility.ACTIVATION -> this.ACTIVATION_SPRITES;
            case WaystoneVisibility.GLOBAL -> this.GLOBAL_SPRITES;
            case WaystoneVisibility.SHARD_ONLY -> this.SHARD_ONLY_SPRITES;
            case WaystoneVisibility.ORANGE_SHARESTONE, WaystoneVisibility.GRAY_SHARESTONE, WaystoneVisibility.LIGHT_GRAY_SHARESTONE, WaystoneVisibility.BLACK_SHARESTONE, WaystoneVisibility.RED_SHARESTONE, WaystoneVisibility.GREEN_SHARESTONE, WaystoneVisibility.BROWN_SHARESTONE, WaystoneVisibility.BLUE_SHARESTONE, WaystoneVisibility.PURPLE_SHARESTONE, WaystoneVisibility.CYAN_SHARESTONE, WaystoneVisibility.PINK_SHARESTONE, WaystoneVisibility.LIME_SHARESTONE, WaystoneVisibility.YELLOW_SHARESTONE, WaystoneVisibility.LIGHT_BLUE_SHARESTONE, WaystoneVisibility.MAGENTA_SHARESTONE -> this.SHARESTONE_SPRITES;
        };
    }

    public void onPress() {
        if (this.canEdit) {
            int index = this.options.indexOf((Object)this.visibility);
            this.visibility = this.options.get((index + 1) % this.options.size());
        }
    }
}

