/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.mining_helmet;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class MHConfig {
    public static final ModConfigSpec CLIENT_SPEC;
    public static final ModConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ServerConfig SERVER;

    public static boolean helmetCoversFace() {
        return (Boolean)MHConfig.CLIENT.helmetCoversFace.get();
    }

    public static int lightRefreshRate() {
        return (Integer)MHConfig.CLIENT.lightRefreshRate.get();
    }

    public static int maxVisibleDistance() {
        return (Integer)MHConfig.CLIENT.maxVisibleDistance.get();
    }

    public static boolean seeThroughWalls() {
        return (Boolean)MHConfig.CLIENT.seeThroughWalls.get();
    }

    public static int getHelmetLightLevel() {
        return (Integer)MHConfig.CLIENT.helmetLightLevel.get();
    }

    public static int minerSpawnChance() {
        return (Integer)MHConfig.SERVER.minerSpawnChance.get();
    }

    static {
        Pair clientPair = new ModConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)clientPair.getLeft();
        CLIENT_SPEC = (ModConfigSpec)clientPair.getRight();
        Pair serverPair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        SERVER = (ServerConfig)serverPair.getLeft();
        SERVER_SPEC = (ModConfigSpec)serverPair.getRight();
    }

    private static class ClientConfig {
        public final ModConfigSpec.ConfigValue<Boolean> helmetCoversFace;
        public final ModConfigSpec.ConfigValue<Integer> lightRefreshRate;
        public final ModConfigSpec.ConfigValue<Integer> maxVisibleDistance;
        public final ModConfigSpec.ConfigValue<Boolean> seeThroughWalls;
        public final ModConfigSpec.ConfigValue<Integer> helmetLightLevel;

        public ClientConfig(ModConfigSpec.Builder builder) {
            builder.comment("Miner's Helmet Client Config");
            builder.push("Helmet Visuals");
            this.helmetCoversFace = builder.comment("\n The Mining Helmet will cover the face of whatever mob is wearing it. Requires reloading resources, or restarting the game.").define("helmetCoversFace", true);
            builder.pop();
            builder.push("Dynamic Lighting (NOTE: These options do nothing with Lucent installed)");
            this.lightRefreshRate = builder.comment("\n The rate at which the Mining Helmet refreshes it's light (measured in ticks). Lower values are smoother but result in worse fps.").defineInRange("lightRefreshRate", 2, 1, Integer.MAX_VALUE);
            this.maxVisibleDistance = builder.comment("\n How far away you should be able to see light from a mining helmet from other mobs (measured in blocks). 0 for infinite distance. Use this to prevent far away mobs from causing light updates.").defineInRange("maxVisibleDistance", 128, 0, Integer.MAX_VALUE);
            this.seeThroughWalls = builder.comment("\n Should dynamic lighting still occur if an entity is behind a wall. Turning this on may impact performance, but allows light to be seen around corners.").define("seeThroughWalls", false);
            this.helmetLightLevel = builder.comment("\n The light level emitted by the helmet.").defineInRange("helmetLightLevel", 12, 0, 15);
            builder.pop();
        }
    }

    private static class ServerConfig {
        public final ModConfigSpec.ConfigValue<Integer> minerSpawnChance;

        public ServerConfig(ModConfigSpec.Builder builder) {
            builder.comment("Miner's Helmet Common Config");
            builder.push("Mobs");
            this.minerSpawnChance = builder.comment("\n The chance for applicably tagged mobs to spawn with a Mining Helmet (1 in x, 0 prevents them from spawning with helmets)").define("minerSpawnChance", (Object)20);
            builder.pop();
        }
    }
}

