/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.mining_helmet.client;

import com.legacy.mining_helmet.MHConfig;
import com.legacy.mining_helmet.MHRegistry;
import com.legacy.mining_helmet.client.MHModelLayers;
import com.legacy.mining_helmet.client.MiningHelmetClientEvents;
import com.legacy.mining_helmet.client.model.MiningHelmetModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;

@OnlyIn(value=Dist.CLIENT)
public class MHClient {
    public static void init(IEventBus modBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MHConfig.CLIENT_SPEC);
        NeoForge.EVENT_BUS.register(MiningHelmetClientEvents.class);
        modBus.addListener(MHClient::registerExtenions);
    }

    public static void registerExtenions(RegisterClientExtensionsEvent event) {
        Item helmet = (Item)MHRegistry.ItemReg.MINING_HELMET.get();
        if (!event.isItemRegistered(helmet)) {
            event.registerItem((IClientItemExtensions)MiningHelmetExtension.INSTANCE, new Item[]{helmet});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class MiningHelmetExtension
    implements IClientItemExtensions {
        private static final MiningHelmetExtension INSTANCE = new MiningHelmetExtension();

        private MiningHelmetExtension() {
        }

        public HumanoidModel<?> getHumanoidArmorModel(ItemStack itemStack, EquipmentClientInfo.LayerType layerType, Model original) {
            return new MiningHelmetModel(MiningHelmetExtension.getModel().bakeLayer(MHModelLayers.MINING_HELMET));
        }

        @OnlyIn(value=Dist.CLIENT)
        private static EntityModelSet getModel() {
            return Minecraft.getInstance().getEntityModels();
        }
    }
}

