/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.mining_helmet.data;

import com.legacy.mining_helmet.MHRegistry;
import com.legacy.mining_helmet.MHTags;
import com.legacy.mining_helmet.data.MHModelProv;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.DetectedVersion;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ItemTagsProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber
public class MHDataGen
implements IModBusEvent {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        boolean run = true;
        CompletableFuture lookup = event.getLookupProvider();
        BlockTagsProvider prov = new BlockTagsProvider(output, lookup, "mining_helmet"){

            protected void addTags(HolderLookup.Provider provider) {
            }
        };
        gen.addProvider(run, (DataProvider)prov);
        ItemTagsProvider itemProv = new ItemTagsProvider(output, lookup, "mining_helmet"){

            protected void addTags(HolderLookup.Provider provider) {
                this.tag(MHTags.REPAIRS_MINING_HELMET).addTag(ItemTags.REPAIRS_IRON_ARMOR);
            }
        };
        gen.addProvider(run, (DataProvider)itemProv);
        EntityTypeTagsProvider entityProv = new EntityTypeTagsProvider(output, lookup, "mining_helmet"){

            protected void addTags(HolderLookup.Provider provider) {
                this.tag(MHTags.MINING_MOBS).add((Object[])new EntityType[]{EntityType.ZOMBIE, EntityType.HUSK, EntityType.ZOMBIE_VILLAGER});
            }
        };
        gen.addProvider(run, (DataProvider)entityProv);
        gen.addProvider(run, (DataProvider)new RecipeProvider.Runner(output, lookup){

            public String getName() {
                return "mining_helmet Recipe Gen";
            }

            protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
                return new VanillaRecipeProvider(this, registries, output){

                    protected void buildRecipes() {
                        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)MHRegistry.ItemReg.MINING_HELMET.get())).define(Character.valueOf('#'), (ItemLike)Items.LANTERN).define(Character.valueOf('L'), Tags.Items.LEATHERS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).pattern(" # ").pattern("LIL").pattern("I I").unlockedBy("has_iron", this.has(Tags.Items.INGOTS_IRON)).unlockedBy("has_lantern", this.has((ItemLike)Items.LANTERN)).save(this.output);
                    }
                };
            }
        });
        gen.addProvider(run, (DataProvider)new MHModelProv(output));
        gen.addProvider(run, (DataProvider)new MHModelProv.Equipment(output));
        gen.addProvider(run, MHDataGen.packMcmeta(output, "Miner's Helmet resources"));
    }

    private static final DataProvider packMcmeta(PackOutput output, String description) {
        int serverVersion = DetectedVersion.BUILT_IN.packVersion(PackType.SERVER_DATA);
        return NestedDataProvider.of(new PackMetadataGenerator(output).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.literal((String)description), serverVersion, Optional.of(new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE))))), description);
    }

    private record NestedDataProvider<D extends DataProvider>(D provider, String namePrefix) implements DataProvider
    {
        public static <D extends DataProvider> NestedDataProvider<D> of(D provider, String namePrefix) {
            return new NestedDataProvider<D>(provider, namePrefix);
        }

        public CompletableFuture<?> run(CachedOutput cachedOutput) {
            return this.provider.run(cachedOutput);
        }

        public String getName() {
            return this.namePrefix + "/" + this.provider.getName();
        }
    }
}

