/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tradecycling.compatibility;

import de.maxhenkel.tradecycling.TradeCyclingMod;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.trading.MerchantOffers;

public class VisibleTraders {
    @Nullable
    private static Method regenerateTrades;
    @Nullable
    private static Method getMerchantOffers;
    @Nullable
    private static Method getLevel;

    public static void forceTradeGeneration(Villager villager) {
        if (regenerateTrades == null) {
            return;
        }
        try {
            regenerateTrades.invoke((Object)villager, new Object[0]);
        }
        catch (Throwable e) {
            TradeCyclingMod.LOGGER.error("Failed to regenerate visible traders trades", e);
            regenerateTrades = null;
        }
    }

    public static MerchantOffers getOffers(Villager villager) {
        if (getMerchantOffers == null) {
            return villager.getOffers();
        }
        try {
            return (MerchantOffers)getMerchantOffers.invoke((Object)villager, new Object[0]);
        }
        catch (Throwable e) {
            TradeCyclingMod.LOGGER.error("Failed to regenerate visible traders trades", e);
            getMerchantOffers = null;
            return villager.getOffers();
        }
    }

    public static int getLevel(Villager villager) {
        if (getLevel == null) {
            return villager.getVillagerData().level();
        }
        try {
            return (Integer)getLevel.invoke((Object)villager, new Object[0]);
        }
        catch (Throwable e) {
            TradeCyclingMod.LOGGER.error("Failed to regenerate visible traders trades", e);
            getLevel = null;
            return villager.getVillagerData().level();
        }
    }

    public static void init(TradeCyclingMod mod) {
        if (!mod.isModLoaded("visibletraders")) {
            return;
        }
        regenerateTrades = VisibleTraders.getRegenerateMethod();
        getMerchantOffers = VisibleTraders.getMerchantOffersMethod();
        getLevel = VisibleTraders.getLevelMethod();
    }

    private static Method getRegenerateMethod() {
        try {
            Method forceTradeGeneration = Villager.class.getDeclaredMethod("visibleTrades$regenerateTrades", new Class[0]);
            forceTradeGeneration.setAccessible(true);
            return forceTradeGeneration;
        }
        catch (Throwable e) {
            TradeCyclingMod.LOGGER.error("Failed to initialize visible traders integration", e);
            return null;
        }
    }

    private static Method getMerchantOffersMethod() {
        try {
            Method getMerchantOffers = Villager.class.getDeclaredMethod("visibleTraders$getCombinedOffers", new Class[0]);
            getMerchantOffers.setAccessible(true);
            return getMerchantOffers;
        }
        catch (Throwable e) {
            TradeCyclingMod.LOGGER.error("Failed to initialize visible traders integration", e);
            return null;
        }
    }

    private static Method getLevelMethod() {
        try {
            Method getLevel = Villager.class.getDeclaredMethod("visibleTraders$getShiftedLevel", new Class[0]);
            getLevel.setAccessible(true);
            return getLevel;
        }
        catch (Throwable e) {
            TradeCyclingMod.LOGGER.error("Failed to initialize visible traders integration", e);
            return null;
        }
    }
}

