/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.world.feature;

import com.google.common.collect.ImmutableList;
import com.izofar.takesapillage.common.util.MobLists;
import com.izofar.takesapillage.common.versions.VersionedEntitySpawnReason;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MobFeature<T extends Mob>
extends Feature<NoneFeatureConfiguration> {
    private final Supplier<WeightedList<EntityType<? extends T>>> entityTypes;

    public MobFeature(Supplier<WeightedList<EntityType<? extends T>>> entityTypes) {
        super(NoneFeatureConfiguration.CODEC);
        this.entityTypes = entityTypes;
    }

    public MobFeature(EntityType<? extends T> entityType) {
        super(NoneFeatureConfiguration.CODEC);
        this.entityTypes = () -> MobLists.createWeightedList(ImmutableList.of(MobLists.createWeightedEntry(entityType, 1)));
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos position = context.origin().below();
        EntityType entityType = (EntityType)this.entityTypes.get().getRandom(context.random()).get();
        Mob entity = (Mob)entityType.create((Level)context.level().getLevel(), VersionedEntitySpawnReason.STRUCTURE);
        if (entity == null) {
            return false;
        }
        entity.snapTo((double)position.getX() + 0.5, (double)position.getY(), (double)position.getZ() + 0.5, 0.0f, 0.0f);
        entity.finalizeSpawn((ServerLevelAccessor)context.level(), context.level().getCurrentDifficultyAt(position), VersionedEntitySpawnReason.STRUCTURE, null);
        entity.setPersistenceRequired();
        context.level().addFreshEntity((Entity)entity);
        return true;
    }
}

