/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.arcanelanterns.world.level.block.entity.LanternMakerBlockEntity;
import java.util.function.Predicate;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class LanternMakerRenderer
implements BlockEntityRenderer<LanternMakerBlockEntity> {
    private final ItemRenderer itemRenderer;

    public LanternMakerRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(LanternMakerBlockEntity blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, Vec3 cameraPosition) {
        NonNullList<ItemStack> items = blockEntity.getContainerItems();
        if (!items.isEmpty()) {
            int posData = (int)blockEntity.getBlockPos().asLong();
            float totalTicks = (float)blockEntity.getLevel().getGameTime() + tickDelta;
            long filledSlots = items.stream().filter(Predicate.not(ItemStack::isEmpty)).count();
            float itemRenderAngle = 360.0f / (float)filledSlots;
            for (int i = 0; i < items.size(); ++i) {
                if (((ItemStack)items.get(i)).isEmpty()) continue;
                matrices.pushPose();
                matrices.translate(0.5f, 1.15f, 0.5f);
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)i * itemRenderAngle + totalTicks));
                matrices.translate(0.75f, 0.0f, 0.25f);
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(totalTicks % 360.0f));
                matrices.translate(0.0, 0.075 * Math.sin(((double)totalTicks + (double)i * 10.0) / 5.0), 0.0);
                this.itemRenderer.renderStatic((ItemStack)items.get(i), ItemDisplayContext.GROUND, light, overlay, matrices, vertexConsumers, blockEntity.getLevel(), posData + i);
                matrices.popPose();
            }
        }
    }
}

