/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.integration.rei;

import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.integration.LanternMakingRecipeHelper;
import fuzs.arcanelanterns.integration.rei.LanternMakingDisplay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;

public class LanternMakingCategory
implements DisplayCategory<LanternMakingDisplay> {
    public CategoryIdentifier<? extends LanternMakingDisplay> getCategoryIdentifier() {
        return LanternMakingDisplay.CATEGORY;
    }

    public Component getTitle() {
        return LanternMakingRecipeHelper.LANTERN_MAKING_COMPONENT;
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)ModRegistry.LANTERN_MAKER_BLOCK.value()));
    }

    public List<Widget> setupDisplay(LanternMakingDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 80, bounds.getCenterY() - 43);
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createDrawableWidget((guiGraphics, mouseX, mouseY, partialTick) -> guiGraphics.blit(RenderPipelines.GUI_TEXTURED, LanternMakingRecipeHelper.TEXTURE_LOCATION, startPoint.x, startPoint.y, 0.0f, 0.0f, 161, 86, 256, 256)));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 131, startPoint.y + 56)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 42, startPoint.y + 35)).entry(EntryStacks.of((ItemLike)((ItemLike)ModRegistry.LANTERN_MAKER_ITEM.value()))).disableBackground().notInteractable());
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 131, startPoint.y + 14)).entries(List.of(EntryStacks.of((ItemLike)Items.LANTERN), EntryStacks.of((ItemLike)Items.SOUL_LANTERN))).markInput());
        double angleBetweenEach = 360.0 / (double)display.getInputEntries().size();
        Vec2 point = new Vec2(42.0f, 3.0f);
        Vec2 center = new Vec2(42.0f, 35.0f);
        for (EntryIngredient ingredient : display.getInputEntries()) {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + (int)point.x, startPoint.y + (int)point.y)).entries((Collection)ingredient).markInput());
            point = LanternMakingRecipeHelper.rotatePointAbout(point, center, angleBetweenEach);
        }
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startPoint.x + 131, startPoint.y + 56)).entries((Collection)display.getOutputEntries().getFirst()).disableBackground().markOutput());
        return widgets;
    }

    public int getDisplayHeight() {
        return 93;
    }

    public int getDisplayWidth(LanternMakingDisplay display) {
        return 168;
    }
}

