/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.network;

import fuzs.puzzleslib.api.network.v4.message.MessageListener;
import fuzs.puzzleslib.api.network.v4.message.play.ClientboundPlayMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;

public record ClientboundBorealParticlesMessage(BlockPos blockPos, BlockPos entityPos) implements ClientboundPlayMessage
{
    public static final StreamCodec<ByteBuf, ClientboundBorealParticlesMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ClientboundBorealParticlesMessage::blockPos, (StreamCodec)BlockPos.STREAM_CODEC, ClientboundBorealParticlesMessage::entityPos, ClientboundBorealParticlesMessage::new);

    public MessageListener<ClientboundPlayMessage.Context> getListener() {
        return new MessageListener<ClientboundPlayMessage.Context>(){

            public void accept(ClientboundPlayMessage.Context context) {
                BlockPos blockPos = ClientboundBorealParticlesMessage.this.blockPos;
                BlockPos entityPos = ClientboundBorealParticlesMessage.this.entityPos;
                RandomSource randomSource = context.level().random;
                for (int i = 0; i < 2; ++i) {
                    double posX = (double)blockPos.getX() + randomSource.nextDouble();
                    double posY = (double)blockPos.getY() + randomSource.nextDouble();
                    double posZ = (double)blockPos.getZ() + randomSource.nextDouble();
                    double speedX = (double)(entityPos.getX() - blockPos.getX()) / 10.0;
                    double speedY = ((double)entityPos.getY() + randomSource.nextDouble() - (double)blockPos.getY()) / 10.0;
                    double speedZ = (double)(entityPos.getZ() - blockPos.getZ()) / 10.0;
                    context.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, posX, posY, posZ, speedX, speedY, speedZ);
                }
            }
        };
    }
}

