/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.level.block;

import com.mojang.serialization.MapCodec;
import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.world.level.block.entity.LanternMakerBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LanternMakerBlock
extends BaseEntityBlock
implements TickingEntityBlock<LanternMakerBlockEntity> {
    public static final MapCodec<LanternMakerBlock> CODEC = LanternMakerBlock.simpleCodec(LanternMakerBlock::new);
    public static final VoxelShape TOP_SHAPE = Block.box((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape CENTER_SHAPE = Block.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0);
    public static final VoxelShape BASE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0);
    public static final VoxelShape FULL_SHAPE = Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{CENTER_SHAPE, BASE_SHAPE});

    public LanternMakerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntityType<? extends LanternMakerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.LANTERN_MAKER_BLOCK_ENTITY.value();
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return FULL_SHAPE;
    }

    protected InteractionResult useItemOn(ItemStack itemInHand, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LanternMakerBlockEntity) {
            LanternMakerBlockEntity blockEntity2 = (LanternMakerBlockEntity)blockEntity;
            if (!itemInHand.isEmpty()) {
                if (level.getBlockState(pos.above()).isAir()) {
                    if (itemInHand.is(Items.LANTERN) || itemInHand.is(Items.SOUL_LANTERN)) {
                        return InteractionResultHelper.SKIP_DEFAULT_BLOCK_INTERACTION;
                    }
                    for (int i = 0; i < blockEntity2.getContainerSize(); ++i) {
                        if (!blockEntity2.getItem(i).isEmpty()) continue;
                        if (!level.isClientSide) {
                            if (player.getAbilities().instabuild) {
                                itemInHand = itemInHand.copy();
                            }
                            blockEntity2.setItem(i, itemInHand.split(1));
                            blockEntity2.setChanged();
                        }
                        return InteractionResultHelper.sidedSuccess((boolean)level.isClientSide);
                    }
                }
                return InteractionResultHelper.CONSUME;
            }
            if (player.isSecondaryUseActive()) {
                for (int i = blockEntity2.getContainerSize() - 1; i >= 0; --i) {
                    if (blockEntity2.getItem(i).isEmpty()) continue;
                    if (!level.isClientSide) {
                        ItemStack itemStack = blockEntity2.removeItem(i, 1);
                        blockEntity2.setChanged();
                        LanternMakerBlockEntity.dropItemStack(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, itemStack);
                    }
                    return InteractionResultHelper.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        return InteractionResultHelper.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, boolean movedByPiston) {
        Containers.updateNeighboursAfterDestroy((BlockState)blockState, (Level)serverLevel, (BlockPos)blockPos);
    }

    public Component getDescriptionComponent() {
        return Component.translatable((String)(this.getDescriptionId() + ".description")).withStyle(ChatFormatting.GOLD);
    }
}

