/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.level.block.entity;

import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.network.ClientboundCraftLanternParticlesMessage;
import fuzs.arcanelanterns.world.item.crafting.LanternMakingRecipe;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.puzzleslib.api.container.v1.ContainerSerializationHelper;
import fuzs.puzzleslib.api.container.v1.ListBackedContainer;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.api.network.v4.message.Message;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class LanternMakerBlockEntity
extends BlockEntity
implements CraftingContainer,
ListBackedContainer,
TickingBlockEntity {
    private final RecipeManager.CachedCheck<CraftingInput, LanternMakingRecipe> quickCheck;
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)16, (Object)ItemStack.EMPTY);

    public LanternMakerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.LANTERN_MAKER_BLOCK_ENTITY.value(), pos, state);
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)ModRegistry.LANTERN_MAKING_RECIPE_TYPE.value()));
    }

    public void serverTick() {
        BlockPos posAbove = this.getBlockPos().above();
        BlockState stateAbove = this.getLevel().getBlockState(posAbove);
        if (stateAbove.is(Blocks.LANTERN) || stateAbove.is(Blocks.SOUL_LANTERN)) {
            ItemStack result = this.quickCheck.getRecipeFor((RecipeInput)this.asCraftInput(), (ServerLevel)this.getLevel()).map(recipe -> ((LanternMakingRecipe)recipe.value()).assemble(this.asCraftInput(), (HolderLookup.Provider)this.getLevel().registryAccess())).orElse(ItemStack.EMPTY);
            if (!result.isEmpty()) {
                for (ItemStack stack : this.items) {
                    if (stack.isEmpty()) continue;
                    stack.shrink(1);
                }
                this.setChanged();
                this.getLevel().destroyBlock(posAbove, false);
                LanternMakerBlockEntity.dropItemStack(this.getLevel(), (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 1.0, (double)this.getBlockPos().getZ() + 0.5, result);
                MessageSender.broadcast((PlayerSet)PlayerSet.nearBlockEntity((BlockEntity)this), (Message)new ClientboundCraftLanternParticlesMessage(this.getBlockPos()));
            } else {
                LanternMakerBlockEntity.destroyBlockDropCentered(this.getLevel(), stateAbove, posAbove);
            }
        }
    }

    public static void dropItemStack(Level level, double posX, double posY, double posZ, ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(level, posX, posY, posZ, stack);
        itemEntity.setDeltaMovement(Vec3.ZERO);
        itemEntity.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)itemEntity);
    }

    private static void destroyBlockDropCentered(Level level, BlockState state, BlockPos pos) {
        BlockEntity blockEntityAbove = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        level.destroyBlock(pos, false);
        Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)blockEntityAbove, null, (ItemStack)ItemStack.EMPTY).forEach(itemStack -> LanternMakerBlockEntity.dropItemStack(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, itemStack));
        state.spawnAfterBreak((ServerLevel)level, pos, ItemStack.EMPTY, true);
    }

    public void fillStackedContents(StackedItemContents stackedContents) {
        for (ItemStack itemStack : this.items) {
            stackedContents.accountSimpleStack(itemStack);
        }
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    public List<ItemStack> getItems() {
        return this.getContainerItems();
    }

    public NonNullList<ItemStack> getContainerItems() {
        return this.items;
    }

    public int getMaxStackSize() {
        return 1;
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        ContainerSerializationHelper.loadAllItems((ValueInput)valueInput, this.items);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ContainerSerializationHelper.saveAllItems((ValueOutput)valueOutput, this.items);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

