/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.level.block.entity;

import fuzs.arcanelanterns.ArcaneLanterns;
import fuzs.arcanelanterns.config.ServerConfig;
import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.network.ClientboundWailingSoundsMessage;
import fuzs.arcanelanterns.world.level.block.entity.LanternBlockEntity;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.api.network.v4.message.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class WailingLanternBlockEntity
extends LanternBlockEntity {
    public WailingLanternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.WAILING_LANTERN_BLOCK_ENTITY.value(), pos, state);
    }

    @Override
    public void serverTick() {
        ServerConfig.EffectLanternConfig config = ((ServerConfig)ArcaneLanterns.CONFIG.get(ServerConfig.class)).wailingLantern;
        if (++this.ticks <= config.delay) {
            return;
        }
        int horizontalRange = config.horizontalRange;
        int verticalRange = config.verticalRange;
        this.getLevel().getEntitiesOfClass(Player.class, new AABB((double)this.getBlockPos().getX() + 0.5 - (double)horizontalRange, (double)this.getBlockPos().getY() + 0.5 - (double)verticalRange, (double)this.getBlockPos().getZ() + 0.5 - (double)horizontalRange, (double)this.getBlockPos().getX() + 0.5 + (double)horizontalRange, (double)this.getBlockPos().getY() + 0.5 + (double)verticalRange, (double)this.getBlockPos().getZ() + 0.5 + (double)horizontalRange), EntitySelector.NO_SPECTATORS).forEach(player -> {
            if (!player.blockPosition().closerThan((Vec3i)this.getBlockPos(), 5.0)) {
                MessageSender.broadcast((PlayerSet)PlayerSet.nearBlockEntity((BlockEntity)this), (Message)new ClientboundWailingSoundsMessage(this.getBlockPos(), false));
            } else {
                player.addEffect(new MobEffectInstance(MobEffects.NAUSEA, config.effectDuration * 20, 0));
                MessageSender.broadcast((PlayerSet)PlayerSet.nearBlockEntity((BlockEntity)this), (Message)new ClientboundWailingSoundsMessage(this.getBlockPos(), true));
            }
        });
        this.ticks = 0;
    }
}

