/*
 * Decompiled with CFR 0.152.
 */
package com.mcwstairs.kikoz.objects;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BalconyRailing
extends Block {
    public static final EnumProperty<RailingStyle> STYLE = EnumProperty.create((String)"style", RailingStyle.class);
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    private static final VoxelShape VEAST = Block.box((double)16.0, (double)0.0, (double)0.0, (double)18.0, (double)15.0, (double)16.0);
    private static final VoxelShape VSOUTH = Block.box((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0, (double)18.0);
    private static final VoxelShape VWEST = Block.box((double)-2.0, (double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0);
    private static final VoxelShape VNORTH = Block.box((double)0.0, (double)0.0, (double)-2.0, (double)16.0, (double)15.0, (double)0.0);
    public static final VoxelShape E_COLLISION = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)26.0, (double)16.0);
    public static final VoxelShape S_COLLISION = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)26.0, (double)16.0);
    public static final VoxelShape W_COLLISION = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)26.0, (double)16.0);
    public static final VoxelShape N_COLLISION = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)26.0, (double)1.0);
    public static final VoxelShape EMPTY = Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    private static final VoxelShape VBASE_COLLISION = Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0);
    private static final VoxelShape VBASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.01, (double)16.0);

    public BalconyRailing(BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue(STYLE, (Comparable)((Object)RailingStyle.CLASSIC)));
    }

    protected VoxelShape getOcclusionShape(BlockState state) {
        return EMPTY;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos().below();
        Level world = context.getLevel();
        BlockState stateBelow = world.getBlockState(pos);
        if (stateBelow.getBlock() instanceof BalconyRailing) {
            return null;
        }
        Direction direction = context.getHorizontalDirection();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)EAST, (Comparable)Boolean.valueOf(direction == Direction.EAST))).setValue((Property)WEST, (Comparable)Boolean.valueOf(direction == Direction.WEST))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(direction == Direction.NORTH))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(direction == Direction.SOUTH));
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        VoxelShape shape = VBASE;
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)VEAST);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)VWEST);
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)VNORTH);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)VSOUTH);
        }
        return shape;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        VoxelShape shape = VBASE_COLLISION;
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)E_COLLISION);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)W_COLLISION);
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)N_COLLISION);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)S_COLLISION);
        }
        return shape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{EAST, WEST, NORTH, SOUTH, STYLE});
    }

    protected InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(handIn);
        Item item = heldItem.getItem();
        if (heldItem.getItem() instanceof BlockItem && ((BlockItem)heldItem.getItem()).getBlock() instanceof BalconyRailing) {
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            Direction direction = player.getDirection();
            BooleanProperty directionProperty = this.getDirectionProperty(direction);
            boolean currentDirectionValue = (Boolean)state.getValue((Property)directionProperty);
            if (!currentDirectionValue) {
                BlockState newState = (BlockState)state.setValue((Property)directionProperty, (Comparable)Boolean.valueOf(true));
                level.setBlock(pos, newState, 3);
                if (!player.getAbilities().instabuild) {
                    heldItem.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (item == Items.SHEARS) {
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            RailingStyle currentStyle = (RailingStyle)((Object)state.getValue(STYLE));
            RailingStyle[] styles = RailingStyle.values();
            int newIndex = (currentStyle.ordinal() + 1) % styles.length;
            RailingStyle newStyle = styles[newIndex];
            BlockState newState = (BlockState)state.setValue(STYLE, (Comparable)((Object)newStyle));
            level.setBlock(pos, newState, 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private BooleanProperty getDirectionProperty(Direction direction) {
        switch (direction) {
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
        }
        throw new IllegalArgumentException("Unexpected direction: " + String.valueOf(direction));
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide && !player.isCreative()) {
            int dropCount = 0;
            if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
                ++dropCount;
            }
            if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                ++dropCount;
            }
            if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
                ++dropCount;
            }
            if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
                ++dropCount;
            }
            ItemStack stack = new ItemStack((ItemLike)this);
            for (int i = 0; i < dropCount; ++i) {
                BalconyRailing.popResource((Level)level, (BlockPos)pos, (ItemStack)stack.copy());
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return false;
    }

    public static enum RailingStyle implements StringRepresentable
    {
        CLASSIC("classic"),
        HARP("harp"),
        SMOOTH("smooth");

        private final String name;

        private RailingStyle(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

