/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.frozenhappyghast.mixin;

import com.cerbon.frozenhappyghast.particle.FHGParticles;
import com.cerbon.frozenhappyghast.util.mixin.IHappyGhastMixin;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.HappyGhast;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HappyGhast.class})
public abstract class HappyGhastMixin
extends Animal
implements IHappyGhastMixin {
    @Unique
    private boolean fhg$isFrozen = false;
    @Unique
    private float fhg$xRotFrozen = 0.0f;
    @Unique
    private float fhg$yRotFrozen = 0.0f;
    @Unique
    private String fhg$isFrozenTag = "fhg_isFrozen";
    @Unique
    private String fhg$xRotFrozenTag = "fhg_xRotFrozen";
    @Unique
    private String fhg$yRotFrozenTag = "fhg_yRotFrozen";
    @Unique
    private static final EntityDataAccessor<Boolean> FHG_IS_FROZEN = SynchedEntityData.defineId(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    protected HappyGhastMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at={@At(value="TAIL")})
    private void fhg$defineSynchedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(FHG_IS_FROZEN, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="TAIL")})
    private void fhg$saveAdditional(ValueOutput valueOutput, CallbackInfo ci) {
        valueOutput.putBoolean(this.fhg$isFrozenTag, this.fhg$isFrozen);
        valueOutput.putFloat(this.fhg$xRotFrozenTag, this.fhg$xRotFrozen);
        valueOutput.putFloat(this.fhg$yRotFrozenTag, this.fhg$yRotFrozen);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="TAIL")})
    private void fhg$readAdditional(ValueInput valueInput, CallbackInfo ci) {
        this.fhg$isFrozen = valueInput.getBooleanOr(this.fhg$isFrozenTag, this.fhg$isFrozen);
        this.fhg$xRotFrozen = valueInput.getFloatOr(this.fhg$xRotFrozenTag, this.fhg$xRotFrozen);
        this.fhg$yRotFrozen = valueInput.getFloatOr(this.fhg$yRotFrozenTag, this.fhg$yRotFrozen);
        ((HappyGhast)this).getEntityData().set(FHG_IS_FROZEN, (Object)this.fhg$isFrozen);
    }

    @WrapOperation(method={"isOnStillTimeout()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/HappyGhast;staysStill()Z")})
    private boolean fhg$isOnStillTimeout(HappyGhast instance, Operation<Boolean> original) {
        if (this.fhg$isFrozen()) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @Inject(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void fhg$travel(Vec3 travelVector, CallbackInfo ci) {
        if (this.fhg$isFrozen()) {
            this.setDeltaMovement(Vec3.ZERO);
            ci.cancel();
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void fhg$tick(CallbackInfo ci) {
        if (this.fhg$isFrozen()) {
            Level level;
            if (this.isBaby()) {
                this.forceSetRotation(this.fhg$yRotFrozen, this.fhg$xRotFrozen);
            }
            if (this.level().getGameTime() % 80L == 0L && (level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.fhg$spawnFrozenParticles(serverLevel);
            }
        }
    }

    @Unique
    private void fhg$spawnFrozenParticles(ServerLevel level) {
        double entityWidth = this.getBbWidth();
        double entityHeight = this.getBbHeight();
        int particleCount = !this.isBaby() ? 8 + this.random.nextInt(5) : 2 + this.random.nextInt(2);
        for (int i = 0; i < particleCount; ++i) {
            double offsetY;
            double offsetZ;
            double offsetX;
            if (this.random.nextFloat() < 0.7f) {
                int side = this.random.nextInt(4);
                switch (side) {
                    case 0: {
                        offsetX = -(entityWidth / 2.0) - 0.1;
                        offsetZ = (double)(this.random.nextFloat() - 0.5f) * entityWidth;
                        break;
                    }
                    case 1: {
                        offsetX = entityWidth / 2.0 + 0.1;
                        offsetZ = (double)(this.random.nextFloat() - 0.5f) * entityWidth;
                        break;
                    }
                    case 2: {
                        offsetZ = -(entityWidth / 2.0) - 0.1;
                        offsetX = (double)(this.random.nextFloat() - 0.5f) * entityWidth;
                        break;
                    }
                    default: {
                        offsetZ = entityWidth / 2.0 + 0.1;
                        offsetX = (double)(this.random.nextFloat() - 0.5f) * entityWidth;
                    }
                }
                offsetY = (double)this.random.nextFloat() * (entityHeight * 0.3);
            } else {
                offsetX = (double)(this.random.nextFloat() - 0.5f) * entityWidth * 0.8;
                offsetY = -0.1;
                offsetZ = (double)(this.random.nextFloat() - 0.5f) * entityWidth * 0.8;
            }
            double particleX = this.getX() + offsetX;
            double particleY = this.getY() + offsetY;
            double particleZ = this.getZ() + offsetZ;
            level.sendParticles((ParticleOptions)FHGParticles.FROZEN_PARTICLE.get(), particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean fhg$isFrozen() {
        return (Boolean)((HappyGhast)this).getEntityData().get(FHG_IS_FROZEN);
    }

    @Override
    public void fhg$setFrozen(boolean value) {
        this.fhg$isFrozen = value;
        this.fhg$xRotFrozen = this.getXRot();
        this.fhg$yRotFrozen = this.getYRot();
        ((HappyGhast)this).getEntityData().set(FHG_IS_FROZEN, (Object)value);
    }
}

