/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob;

import baguchi.enchantwithmob.EnchantConfig;
import baguchi.enchantwithmob.api.IEnchantCap;
import baguchi.enchantwithmob.api.IEnchantVisual;
import baguchi.enchantwithmob.capability.MobEnchantHandler;
import baguchi.enchantwithmob.client.ModParticles;
import baguchi.enchantwithmob.item.mobenchant.ItemMobEnchantments;
import baguchi.enchantwithmob.message.MobEnchantedMessage;
import baguchi.enchantwithmob.mobenchant.MobEnchant;
import baguchi.enchantwithmob.registry.MobEnchants;
import baguchi.enchantwithmob.registry.ModDataCompnents;
import baguchi.enchantwithmob.registry.ModItems;
import baguchi.enchantwithmob.utils.MobEnchantUtils;
import baguchi.enchantwithmob.utils.MobEnchantmentData;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="enchantwithmob")
public class CommonEventHandler {
    @SubscribeEvent
    public static void onTraceableEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof IEnchantVisual) {
            TraceableEntity traceableEntity;
            Entity entity2;
            IEnchantVisual enchantVisual = (IEnchantVisual)entity;
            entity = event.getEntity();
            if (entity instanceof TraceableEntity && (entity2 = (traceableEntity = (TraceableEntity)entity).getOwner()) instanceof IEnchantCap) {
                IEnchantCap enchantCap = (IEnchantCap)entity2;
                enchantVisual.setEnchantVisual(enchantCap.getEnchantCap().hasEnchant());
            }
        }
    }

    @SubscribeEvent
    public static void onEnderDragonSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)entity;
            entity = event.getEntity();
            if (entity instanceof EnderDragon) {
                EnderDragon livingEntity = (EnderDragon)entity;
                Level world = event.getLevel();
                if (!world.isClientSide() && !cap.getEnchantCap().hasEnchant()) {
                    float difficultScale;
                    int i;
                    if (CommonEventHandler.isSpawnAlwayEnchantableAncientEntity((Entity)livingEntity)) {
                        i = 0;
                        difficultScale = world.getCurrentDifficultyAt(livingEntity.blockPosition()).getEffectiveDifficulty() - 0.2f;
                        switch (world.getDifficulty()) {
                            case EASY: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(10)) * difficultScale), (float)1.0f, (float)30.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true);
                                break;
                            }
                            case NORMAL: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(15)) * difficultScale), (float)1.0f, (float)60.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true);
                                break;
                            }
                            case HARD: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(20)) * difficultScale), (float)1.0f, (float)100.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true);
                            }
                        }
                        livingEntity.setHealth(livingEntity.getMaxHealth());
                    }
                    if (CommonEventHandler.isSpawnAlwayEnchantableEntity((Entity)livingEntity)) {
                        i = 0;
                        difficultScale = world.getCurrentDifficultyAt(livingEntity.blockPosition()).getEffectiveDifficulty() - 0.2f;
                        switch (world.getDifficulty()) {
                            case EASY: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(5)) * difficultScale), (float)1.0f, (float)20.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true);
                                break;
                            }
                            case NORMAL: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(5)) * difficultScale), (float)1.0f, (float)40.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true);
                                break;
                            }
                            case HARD: {
                                i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(10)) * difficultScale), (float)1.0f, (float)50.0f);
                                MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true);
                            }
                        }
                        livingEntity.setHealth(livingEntity.getMaxHealth());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSpawnEntity(FinalizeSpawnEvent event) {
        Mob mob = event.getEntity();
        if (mob instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)mob;
            ServerLevelAccessor world = event.getLevel();
            if (!world.isClientSide()) {
                int i;
                Mob livingEntity = event.getEntity();
                float difficultScale = world.getCurrentDifficultyAt(livingEntity.blockPosition()).getEffectiveDifficulty() - 0.2f;
                float difficultScaleOnPercent = world.getCurrentDifficultyAt(livingEntity.blockPosition()).getEffectiveDifficulty();
                if (CommonEventHandler.isSpawnAlwayEnchantableAncientEntity((Entity)livingEntity)) {
                    i = 0;
                    switch (world.getDifficulty()) {
                        case EASY: {
                            i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(10)) * difficultScale), (float)1.0f, (float)30.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true);
                            break;
                        }
                        case NORMAL: {
                            i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(15)) * difficultScale), (float)1.0f, (float)60.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true);
                            break;
                        }
                        case HARD: {
                            i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(20)) * difficultScale), (float)1.0f, (float)100.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true);
                        }
                    }
                    livingEntity.setHealth(livingEntity.getMaxHealth());
                }
                if (CommonEventHandler.isSpawnAlwayEnchantableEntity((Entity)livingEntity)) {
                    i = 0;
                    switch (world.getDifficulty()) {
                        case EASY: {
                            i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(5)) * difficultScale), (float)1.0f, (float)20.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true);
                            break;
                        }
                        case NORMAL: {
                            i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(5)) * difficultScale), (float)1.0f, (float)40.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true);
                            break;
                        }
                        case HARD: {
                            i = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(10)) * difficultScale), (float)1.0f, (float)50.0f);
                            MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i, true);
                        }
                    }
                    livingEntity.setHealth(livingEntity.getMaxHealth());
                }
                if (((Boolean)EnchantConfig.COMMON.naturalSpawnEnchantedMob.get()).booleanValue() && CommonEventHandler.isSpawnEnchantableEntity((Entity)event.getEntity()) && (!(livingEntity instanceof Animal) && !(livingEntity instanceof WaterAnimal) || ((Boolean)EnchantConfig.COMMON.spawnEnchantedAnimal.get()).booleanValue())) {
                    if (event.getSpawnType() != EntitySpawnReason.BREEDING && event.getSpawnType() != EntitySpawnReason.CONVERSION && event.getSpawnType() != EntitySpawnReason.STRUCTURE && event.getSpawnType() != EntitySpawnReason.MOB_SUMMONED) {
                        boolean flag;
                        boolean bl = flag = event.getSpawner() != null && CommonEventHandler.isOminousTrialSpawner((Either<BlockEntity, Entity>)event.getSpawner());
                        if ((flag || (double)world.getRandom().nextFloat() < (Double)EnchantConfig.COMMON.difficultyBasePercent.get() * (double)world.getDifficulty().getId() + (double)difficultScaleOnPercent * (Double)EnchantConfig.COMMON.effectiveBasePercent.get()) && !world.isClientSide()) {
                            int i2 = 0;
                            float scale = flag ? 0.5f : 1.0f;
                            difficultScale = flag ? 1.0f : difficultScale;
                            switch (world.getDifficulty()) {
                                case EASY: {
                                    i2 = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(5)) * difficultScale * scale), (float)1.0f, (float)20.0f);
                                    MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i2, true);
                                    break;
                                }
                                case NORMAL: {
                                    i2 = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(5)) * difficultScale * scale), (float)1.0f, (float)40.0f);
                                    MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i2, true);
                                    break;
                                }
                                case HARD: {
                                    i2 = (int)Mth.clamp((float)((float)(5 + world.getRandom().nextInt(10)) * difficultScale * scale), (float)1.0f, (float)50.0f);
                                    MobEnchantUtils.addRandomEnchantmentToEntity((LivingEntity)livingEntity, cap, world.getRandom(), i2, true);
                                }
                            }
                            livingEntity.setHealth(livingEntity.getMaxHealth());
                        }
                    }
                    if (event.getSpawnType() == EntitySpawnReason.TRIAL_SPAWNER && (double)world.getRandom().nextFloat() < (double)0.1f + (double)difficultScaleOnPercent * (Double)EnchantConfig.COMMON.effectiveBasePercent.get()) {
                        MobEnchantUtils.addEnchantmentToEntity((LivingEntity)livingEntity, cap, new MobEnchantmentData((Holder<MobEnchant>)((Holder)world.registryAccess().lookupOrThrow(MobEnchants.MOB_ENCHANT_REGISTRY).get(MobEnchants.WIND.getKey()).get()), 1));
                    }
                }
            }
        }
    }

    private static boolean isOminousTrialSpawner(Either<BlockEntity, Entity> spawner) {
        TrialSpawnerBlockEntity trialSpawnerBlockEntity;
        Object t;
        return spawner.left().isPresent() && (t = spawner.left().get()) instanceof TrialSpawnerBlockEntity && (trialSpawnerBlockEntity = (TrialSpawnerBlockEntity)t).getTrialSpawner().isOminous();
    }

    private static boolean isSpawnAlwayEnchantableEntity(Entity entity) {
        return !(entity instanceof Player) && !(entity instanceof ArmorStand) && !(entity instanceof Boat) && !(entity instanceof Minecart) && ((List)EnchantConfig.COMMON.ALWAY_ENCHANTABLE_MOBS.get()).contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString());
    }

    private static boolean isSpawnAlwayEnchantableAncientEntity(Entity entity) {
        return !(entity instanceof Player) && !(entity instanceof ArmorStand) && !(entity instanceof Boat) && !(entity instanceof Minecart) && ((List)EnchantConfig.COMMON.ALWAY_ENCHANTABLE_ANCIENT_MOBS.get()).contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString());
    }

    private static boolean isSpawnEnchantableEntity(Entity entity) {
        return !(entity instanceof Player) && !(entity instanceof ArmorStand) && !(entity instanceof Boat) && !(entity instanceof Minecart) && !((List)EnchantConfig.COMMON.ENCHANT_ON_SPAWN_EXCLUSION_MOBS.get()).contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString());
    }

    @SubscribeEvent
    public static void onUpdateEnchanted(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)entity;
            if (entity instanceof LivingEntity) {
                Player player;
                LivingEntity livingEntity = (LivingEntity)entity;
                for (MobEnchantHandler enchantHandler : cap.getEnchantCap().getMobEnchants()) {
                    Level level = livingEntity.level();
                    if (!(level instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    ((MobEnchant)enchantHandler.getMobEnchant().value()).tick(livingEntity, enchantHandler.getEnchantLevel());
                }
                if (cap.getEnchantCap().hasEnchant() && entity.level().isClientSide() && !((Boolean)EnchantConfig.CLIENT.disableAuraRender.get()).booleanValue() && (!(entity instanceof Player) || !(player = (Player)entity).isSpectator()) && entity.getRandom().nextFloat() < 0.45f) {
                    entity.level().addParticle((ParticleOptions)(cap.getEnchantCap().isAncient() ? ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER : (ParticleOptions)ModParticles.ENCHANT.get()), entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurtPre(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)livingEntity;
            int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (ResourceKey<MobEnchant>)MobEnchants.THORN.getKey());
            if (event.getSource().getDirectEntity() instanceof LivingEntity && !event.getSource().is(DamageTypeTags.IS_PROJECTILE) && !event.getSource().is(DamageTypes.THORNS) && livingEntity.getRandom().nextFloat() < (float)i * 0.1f) {
                LivingEntity attacker = (LivingEntity)event.getSource().getDirectEntity();
                attacker.hurt(livingEntity.damageSources().thorns((Entity)livingEntity), event.getNewDamage() * ((float)i / 8.0f));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurtPost(LivingDamageEvent.Post event) {
        LivingEntity attacker;
        Level level;
        LivingEntity livingEntity = event.getEntity();
        if (event.getSource().getEntity() instanceof LivingEntity && (level = (attacker = (LivingEntity)event.getSource().getEntity()).level()) instanceof ServerLevel) {
            IEnchantCap cap;
            ServerLevel serverLevel = (ServerLevel)level;
            if (attacker instanceof IEnchantCap && (cap = (IEnchantCap)attacker).getEnchantCap().hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getEnchantCap().getMobEnchants(), (ResourceKey<MobEnchant>)MobEnchants.POISON.getKey())) {
                int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getEnchantCap().getMobEnchants(), (ResourceKey<MobEnchant>)MobEnchants.POISON.getKey());
                if (attacker.getRandom().nextFloat() < (float)i * 0.125f) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 60 * i, 0), (Entity)attacker);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityIncomingDamage(LivingIncomingDamageEvent event) {
        Object cap;
        ServerLevel serverLevel;
        LivingEntity attacker;
        Level level;
        LivingEntity livingEntity = event.getEntity();
        if (event.getSource().getEntity() instanceof LivingEntity && (level = (attacker = (LivingEntity)event.getSource().getEntity()).level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (attacker instanceof IEnchantCap && (cap = (IEnchantCap)attacker).getEnchantCap().hasEnchant()) {
                if (event.getAmount() == 0.0f && event.getContainer().getBlockedDamage() <= 0.0f) {
                    event.setAmount(MobEnchantUtils.modifyDamage(serverLevel, (Entity)attacker, event.getSource(), event.getAmount()));
                } else if (event.getAmount() > 0.0f) {
                    event.setAmount(MobEnchantUtils.modifyDamage(serverLevel, (Entity)attacker, event.getSource(), event.getAmount()));
                }
            }
        }
        if (livingEntity instanceof IEnchantCap) {
            IEnchantCap cap2 = (IEnchantCap)livingEntity;
            if (!event.getSource().is(DamageTypeTags.BYPASSES_EFFECTS) && cap2.getEnchantCap().hasEnchant() && (cap = livingEntity.level()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)cap;
                float f = CombatRules.getDamageAfterMagicAbsorb((float)event.getAmount(), (float)MobEnchantUtils.getDamageProtection(serverLevel, livingEntity, event.getSource()));
                event.setAmount(f);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Entity entityTarget = event.getTarget();
        Player player = event.getEntity();
        if (!(entityTarget instanceof Player)) {
            LivingEntity target;
            if (stack.getItem() == ModItems.MOB_ENCHANT_BOOK.get() && !player.getCooldowns().isOnCooldown(stack) && entityTarget instanceof LivingEntity) {
                target = (LivingEntity)entityTarget;
                if (MobEnchantUtils.hasMobEnchant(stack) && target instanceof IEnchantCap) {
                    IEnchantCap cap = (IEnchantCap)target;
                    boolean flag = MobEnchantUtils.addItemMobEnchantToEntity(stack, target, (LivingEntity)player, cap);
                    if (flag) {
                        player.playSound(SoundEvents.ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
                        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)event.getHand()));
                        player.getCooldowns().addCooldown(stack, 60);
                        event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                        event.setCanceled(true);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"enchantwithmob.cannot.enchant"), true);
                        player.getCooldowns().addCooldown(stack, 20);
                        event.setCancellationResult((InteractionResult)InteractionResult.FAIL);
                        event.setCanceled(true);
                    }
                }
            }
            if (stack.getItem() == ModItems.ENCHANATERS_BOTTLE.get() && !player.getCooldowns().isOnCooldown(stack) && entityTarget instanceof LivingEntity) {
                IEnchantCap cap;
                target = (LivingEntity)entityTarget;
                ItemStack stack1 = new ItemStack((ItemLike)ModItems.ENCHANATERS_EXPERIENCE_BOTTLE.get());
                if (target instanceof IEnchantCap && (cap = (IEnchantCap)target).getEnchantCap().hasEnchant() && !cap.getEnchantCap().isAncient()) {
                    int xp = MobEnchantUtils.getExperienceFromMob(cap);
                    if (xp > 0) {
                        stack1.set((DataComponentType)ModDataCompnents.EXPERIENCE.get(), (Object)xp);
                    }
                    MobEnchantUtils.removeMobEnchantToEntity(target, cap);
                    player.playSound(SoundEvents.ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
                    stack.consume(1, (LivingEntity)player);
                    player.getCooldowns().addCooldown(stack, 80);
                    event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    if (!player.hasInfiniteMaterials() && !player.getInventory().add(stack1)) {
                        player.drop(stack1, false);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack itemstack = event.getLeft();
        int i = 0;
        long j = 0L;
        int k = 0;
        if (!itemstack.isEmpty() && MobEnchantUtils.canStoreEnchantments(itemstack)) {
            ItemStack itemstack1 = itemstack.copy();
            ItemStack itemstack2 = event.getRight();
            ItemMobEnchantments.Mutable itemenchantments$mutable = new ItemMobEnchantments.Mutable(MobEnchantUtils.getEnchantmentsForCrafting(itemstack1));
            j += (long)((Integer)itemstack.getOrDefault(DataComponents.REPAIR_COST, (Object)0)).intValue() + (long)((Integer)itemstack2.getOrDefault(DataComponents.REPAIR_COST, (Object)0)).intValue();
            event.setXpCost(0);
            boolean flag = false;
            if (!itemstack2.isEmpty()) {
                flag = itemstack2.has((DataComponentType)ModDataCompnents.MOB_ENCHANTMENTS.get());
                if (itemstack1.isDamageableItem() && itemstack.isValidRepairItem(itemstack2)) {
                    int j3;
                    int l2 = Math.min(itemstack1.getDamageValue(), itemstack1.getMaxDamage() / 4);
                    if (l2 <= 0) {
                        event.setOutput(ItemStack.EMPTY);
                        event.setXpCost(0);
                        return;
                    }
                    for (j3 = 0; l2 > 0 && j3 < itemstack2.getCount(); ++j3) {
                        int k3 = itemstack1.getDamageValue() - l2;
                        itemstack1.setDamageValue(k3);
                        ++i;
                        l2 = Math.min(itemstack1.getDamageValue(), itemstack1.getMaxDamage() / 4);
                    }
                    event.setXpCost(j3);
                } else {
                    if (!(flag || itemstack1.is(itemstack2.getItem()) && itemstack1.isDamageableItem())) {
                        event.setOutput(ItemStack.EMPTY);
                        event.setXpCost(0);
                        return;
                    }
                    if (itemstack1.isDamageableItem()) {
                        int l = itemstack.getMaxDamage() - itemstack.getDamageValue();
                        int i1 = itemstack2.getMaxDamage() - itemstack2.getDamageValue();
                        int j1 = i1 + itemstack1.getMaxDamage() * 12 / 100;
                        int k1 = l + j1;
                        int l1 = itemstack1.getMaxDamage() - k1;
                        if (l1 < 0) {
                            l1 = 0;
                        }
                        if (l1 < itemstack1.getDamageValue()) {
                            itemstack1.setDamageValue(l1);
                            i += 2;
                        }
                    }
                    ItemMobEnchantments itemenchantments = MobEnchantUtils.getEnchantmentsForCrafting(itemstack2);
                    boolean flag2 = false;
                    boolean flag3 = false;
                    for (Object2IntMap.Entry<Holder<MobEnchant>> entry : itemenchantments.entrySet()) {
                        int j2;
                        Holder holder = (Holder)entry.getKey();
                        int i2 = itemenchantments$mutable.getLevel((MobEnchant)holder.value());
                        j2 = i2 == (j2 = entry.getIntValue()) ? j2 + 1 : Math.max(j2, i2);
                        MobEnchant enchantment = (MobEnchant)holder.value();
                        boolean flag1 = true;
                        if (event.getPlayer().getAbilities().instabuild) {
                            flag1 = true;
                        }
                        for (Holder<MobEnchant> holder1 : itemenchantments$mutable.keySet()) {
                            if (holder1.equals((Object)holder) || MobEnchant.areCompatible((Holder<MobEnchant>)holder, holder1)) continue;
                            flag1 = false;
                            ++i;
                        }
                        if (!flag1) {
                            flag3 = true;
                            continue;
                        }
                        flag2 = true;
                        if (j2 > enchantment.getMaxLevel()) {
                            j2 = enchantment.getMaxLevel();
                        }
                        itemenchantments$mutable.set((MobEnchant)holder.value(), j2);
                        int l3 = enchantment.getAnvilCost();
                        if (flag) {
                            l3 = Math.max(1, l3 / 2);
                        }
                        i += l3 * j2;
                        if (itemstack.getCount() <= 1) continue;
                        i = 40;
                    }
                    if (flag3 && !flag2) {
                        event.setOutput(ItemStack.EMPTY);
                        event.setXpCost(0);
                        return;
                    }
                }
            }
            if (event.getName() != null && !StringUtil.isBlank((String)event.getName())) {
                if (!event.getName().equals(itemstack.getHoverName().getString())) {
                    k = 1;
                    i += k;
                    itemstack1.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)event.getName()));
                }
            } else if (itemstack.has(DataComponents.CUSTOM_NAME)) {
                k = 1;
                i += k;
                itemstack1.remove(DataComponents.CUSTOM_NAME);
            }
            int k2 = i <= 0 ? 0 : (int)Mth.clamp((long)(j + (long)i), (long)0L, (long)Integer.MAX_VALUE);
            event.setXpCost(k2);
            if (i <= 0) {
                itemstack1 = ItemStack.EMPTY;
            }
            if (k == i && k > 0 && event.getXpCost() >= 40) {
                event.setXpCost(39);
            }
            if (event.getXpCost() >= 40 && !event.getPlayer().getAbilities().instabuild) {
                itemstack1 = ItemStack.EMPTY;
            }
            if (!itemstack1.isEmpty()) {
                int i3 = (Integer)itemstack1.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
                if (i3 < (Integer)itemstack2.getOrDefault(DataComponents.REPAIR_COST, (Object)0)) {
                    i3 = (Integer)itemstack2.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
                }
                if (k != i || k == 0) {
                    i3 = AnvilMenu.calculateIncreasedRepairCost((int)i3);
                }
                itemstack1.set(DataComponents.REPAIR_COST, (Object)i3);
                MobEnchantUtils.setEnchantments(itemstack1, itemenchantments$mutable.toImmutable());
            }
            event.setOutput(itemstack1);
        }
    }

    @SubscribeEvent
    public static void onExpDropped(LivingExperienceDropEvent event) {
        IEnchantCap cap;
        LivingEntity entity = event.getEntity();
        if (entity instanceof IEnchantCap && (cap = (IEnchantCap)entity).getEnchantCap().hasEnchant()) {
            if (cap.getEnchantCap().isAncient()) {
                event.setDroppedExperience(event.getDroppedExperience() + MobEnchantUtils.getExperienceFromMob(cap) * 5);
            } else {
                event.setDroppedExperience(event.getDroppedExperience() + MobEnchantUtils.getExperienceFromMob(cap));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player instanceof IEnchantCap) {
                IEnchantCap cap = (IEnchantCap)player;
                for (int i = 0; i < cap.getEnchantCap().getMobEnchants().size(); ++i) {
                    cap.getEnchantCap().onNewEnchantEffect((LivingEntity)serverPlayer, cap.getEnchantCap().getMobEnchants().get(i).getMobEnchant(), cap.getEnchantCap().getMobEnchants().get(i).getEnchantLevel());
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MobEnchantedMessage((Entity)player, cap.getEnchantCap().getMobEnchants().get(i)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player playerEntity = event.getEntity();
        if (playerEntity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)playerEntity;
            if (!playerEntity.level().isClientSide()) {
                for (int i = 0; i < cap.getEnchantCap().getMobEnchants().size(); ++i) {
                    cap.getEnchantCap().onNewEnchantEffect((LivingEntity)playerEntity, cap.getEnchantCap().getMobEnchants().get(i).getMobEnchant(), cap.getEnchantCap().getMobEnchants().get(i).getEnchantLevel());
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)playerEntity, (CustomPacketPayload)new MobEnchantedMessage((Entity)playerEntity, cap.getEnchantCap().getMobEnchants().get(i)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)entity;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!entity.level().isClientSide()) {
                    for (int i = 0; i < cap.getEnchantCap().getMobEnchants().size(); ++i) {
                        cap.getEnchantCap().onNewEnchantEffect(livingEntity, cap.getEnchantCap().getMobEnchants().get(i).getMobEnchant(), cap.getEnchantCap().getMobEnchants().get(i).getEnchantLevel());
                        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new MobEnchantedMessage(entity, cap.getEnchantCap().getMobEnchants().get(i)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        if (!event.isWasDeath()) {
            ((IEnchantCap)oldPlayer).getEnchantCap().getMobEnchants().forEach(mobEnchantHandler -> ((IEnchantCap)newPlayer).getEnchantCap().addMobEnchant((LivingEntity)newPlayer, mobEnchantHandler.getMobEnchant(), mobEnchantHandler.getEnchantLevel()));
        }
    }
}

