/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob;

import baguchi.enchantwithmob.EnchantConfig;
import baguchi.enchantwithmob.client.ModParticles;
import baguchi.enchantwithmob.command.MobEnchantingCommand;
import baguchi.enchantwithmob.message.AncientMessage;
import baguchi.enchantwithmob.message.MobEnchantFromOwnerMessage;
import baguchi.enchantwithmob.message.MobEnchantedMessage;
import baguchi.enchantwithmob.message.RemoveAllMobEnchantMessage;
import baguchi.enchantwithmob.message.RemoveMobEnchantOwnerMessage;
import baguchi.enchantwithmob.message.SoulParticleMessage;
import baguchi.enchantwithmob.registry.MobEnchants;
import baguchi.enchantwithmob.registry.ModAttachments;
import baguchi.enchantwithmob.registry.ModDataCompnents;
import baguchi.enchantwithmob.registry.ModEntities;
import baguchi.enchantwithmob.registry.ModItems;
import baguchi.enchantwithmob.registry.ModLootItemFunctions;
import baguchi.enchantwithmob.registry.ModSounds;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enchantwithmob")
public class EnchantWithMob {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "enchantwithmob";
    public static final String NETWORK_PROTOCOL = "2";

    public EnchantWithMob(ModContainer modContainer, Dist dist, IEventBus modEventBus) {
        if (dist.isClient()) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        modEventBus.addListener(this::preSetup);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::setupPackets);
        ModEntities.ENTITIES_REGISTRY.register(modEventBus);
        ModDataCompnents.DATA_COMPONENT_TYPES.register(modEventBus);
        ModItems.ITEM_REGISTRY.register(modEventBus);
        ModLootItemFunctions.LOOT_REGISTRY.register(modEventBus);
        ModAttachments.ATTACHMENT_TYPES.register(modEventBus);
        ModSounds.SOUND_EVENTS.register(modEventBus);
        ModParticles.PARTICLE_TYPES.register(modEventBus);
        MobEnchants.MOB_ENCHANT.register(modEventBus);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EnchantConfig.COMMON_SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)EnchantConfig.CLIENT_SPEC);
    }

    private void preSetup(FMLConstructModEvent event) {
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    public void setupPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0.0").optional();
        registrar.playToClient(AncientMessage.TYPE, AncientMessage.STREAM_CODEC, (handler, payload) -> handler.handle((AncientMessage)handler, payload));
        registrar.playToClient(MobEnchantedMessage.TYPE, MobEnchantedMessage.STREAM_CODEC, (handler, payload) -> handler.handle((MobEnchantedMessage)handler, payload));
        registrar.playToClient(MobEnchantFromOwnerMessage.TYPE, MobEnchantFromOwnerMessage.STREAM_CODEC, (handler, payload) -> handler.handle((MobEnchantFromOwnerMessage)handler, payload));
        registrar.playToClient(RemoveAllMobEnchantMessage.TYPE, RemoveAllMobEnchantMessage.STREAM_CODEC, (handler, payload) -> handler.handle((RemoveAllMobEnchantMessage)handler, payload));
        registrar.playToClient(RemoveMobEnchantOwnerMessage.TYPE, RemoveMobEnchantOwnerMessage.STREAM_CODEC, (handler, payload) -> handler.handle((RemoveMobEnchantOwnerMessage)handler, payload));
        registrar.playToClient(SoulParticleMessage.TYPE, SoulParticleMessage.STREAM_CODEC, (handler, payload) -> handler.handle((SoulParticleMessage)handler, payload));
    }

    public static ResourceLocation prefix(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void registerCommands(RegisterCommandsEvent evt) {
        MobEnchantingCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }
}

