/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob.client.model;

import baguchi.bagus_lib.client.layer.IArmor;
import baguchi.enchantwithmob.EnchantConfig;
import baguchi.enchantwithmob.client.animation.EnchanterAnimation;
import baguchi.enchantwithmob.client.animation.NormalAnimation;
import baguchi.enchantwithmob.client.render.state.EnchanterRenderState;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class EnchanterModel<T extends EnchanterRenderState>
extends EntityModel<T>
implements IArmor {
    private final ModelPart realRoot;
    private final ModelPart everything;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart body;
    private final ModelPart arms;
    private final ModelPart Cape;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart leftEye;
    private final ModelPart rightEye;
    private final ModelPart righteyebrows;
    private final ModelPart lefteyebrows;
    private final ModelPart left_arm;
    private final ModelPart leftHand;
    private final ModelPart right_arm;
    private final ModelPart rightHand;
    private final KeyframeAnimation walkAnimation;
    private final KeyframeAnimation walkStopAnimation;
    private final KeyframeAnimation castingAnimation;
    private final KeyframeAnimation oldCastingAnimation;
    private final KeyframeAnimation attackAnimation;
    private final KeyframeAnimation oldAttackAnimation;
    private final KeyframeAnimation idleAnimation;
    private final KeyframeAnimation sitAnimation;

    public EnchanterModel(ModelPart root) {
        super(root);
        this.realRoot = root;
        this.everything = root.getChild("everything");
        this.left_leg = this.everything.getChild("left_leg");
        this.right_leg = this.everything.getChild("right_leg");
        this.body = this.everything.getChild("body");
        this.arms = this.body.getChild("arms");
        this.Cape = this.body.getChild("Cape");
        this.head = this.body.getChild("head");
        this.hat = this.head.getChild("hat");
        this.leftEye = this.head.getChild("leftEye");
        this.rightEye = this.head.getChild("rightEye");
        this.righteyebrows = this.head.getChild("righteyebrows");
        this.lefteyebrows = this.head.getChild("lefteyebrows");
        this.left_arm = this.body.getChild("left_arm");
        this.leftHand = this.left_arm.getChild("leftHand");
        this.right_arm = this.body.getChild("right_arm");
        this.rightHand = this.right_arm.getChild("rightHand");
        this.walkAnimation = EnchanterAnimation.WALK.bake(root);
        this.walkStopAnimation = NormalAnimation.WALK_STOP.bake(root);
        this.castingAnimation = EnchanterAnimation.ENCHANCE.bake(root);
        this.oldCastingAnimation = EnchanterAnimation.old_enchant.bake(root);
        this.attackAnimation = EnchanterAnimation.ATTACK.bake(root);
        this.oldAttackAnimation = EnchanterAnimation.old_attack.bake(root);
        this.idleAnimation = EnchanterAnimation.IDLE.bake(root);
        this.sitAnimation = NormalAnimation.SIT.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition everything = partdefinition.addOrReplaceChild("everything", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_leg = everything.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition right_leg = everything.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition body = everything.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, -12.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 38).addBox(-4.0f, -12.0f, -3.0f, 8.0f, 19.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition Cape = body.addOrReplaceChild("Cape", CubeListBuilder.create().texOffs(0, 64).addBox(-6.0f, 0.0f, 0.0f, 12.0f, 23.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)3.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(1, 91).addBox(-5.0f, -8.0f, -5.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(6, 4).addBox(0.0f, -1.4604f, 0.74f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-2.5f, (float)-4.75f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(6, 4).addBox(-1.0f, -1.4604f, 0.74f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-2.5f, (float)-4.75f));
        PartDefinition righteyebrows = head.addOrReplaceChild("righteyebrows", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)-4.9604f, (float)-3.5196f));
        PartDefinition righteyebrows_r1 = righteyebrows.addOrReplaceChild("righteyebrows_r1", CubeListBuilder.create().texOffs(0, 5).addBox(-1.5f, -1.0f, -0.5902f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.0902f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition lefteyebrows = head.addOrReplaceChild("lefteyebrows", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)-4.9604f, (float)-3.5196f));
        PartDefinition lefteyebrows_r1 = lefteyebrows.addOrReplaceChild("lefteyebrows_r1", CubeListBuilder.create().texOffs(0, 5).mirror().addBox(-1.5f, -1.0f, -0.5902f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.0902f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 46).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition leftHand = left_arm.addOrReplaceChild("leftHand", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)11.0f, (float)0.0f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 46).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition rightHand = right_arm.addOrReplaceChild("rightHand", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)11.0f, (float)0.0f));
        PartDefinition arms = body.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(44, 22).mirror().addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(40, 38).addBox(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 22).addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)-0.95f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition book_rotation = partdefinition.addOrReplaceChild("book_rotation", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.5f, (float)1.5f, (float)-7.9f, (float)1.5708f, (float)0.829f, (float)1.5708f));
        PartDefinition book = book_rotation.addOrReplaceChild("book", CubeListBuilder.create().texOffs(43, 72).addBox(-2.0f, -3.0f, -1.0f, 3.0f, 9.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftBookCover = book.addOrReplaceChild("leftBookCover", CubeListBuilder.create().texOffs(26, 72).mirror().addBox(-8.0f, -3.0f, -1.0f, 8.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(44, 62).addBox(-6.9f, -2.5f, -0.5f, 7.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition rightBookCover = book.addOrReplaceChild("rightBookCover", CubeListBuilder.create().texOffs(26, 62).addBox(0.0f, -3.0f, -1.0f, 8.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 62).addBox(-0.1f, -2.5f, -0.5f, 7.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition pages = book.addOrReplaceChild("pages", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)-0.1f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition leftPage = pages.addOrReplaceChild("leftPage", CubeListBuilder.create().texOffs(26, 82).addBox(-7.0f, -3.0f, 0.01f, 7.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition leftPage2 = pages.addOrReplaceChild("leftPage2", CubeListBuilder.create().texOffs(26, 82).addBox(-7.0f, -3.0f, 0.01f, 7.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        this.head.yRot = ((EnchanterRenderState)((Object)entity)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((EnchanterRenderState)((Object)entity)).xRot * ((float)Math.PI / 180);
        this.Cape.xRot = 0.1f + ((EnchanterRenderState)((Object)entity)).walkAnimationSpeed * 0.6f;
        if (((EnchanterRenderState)((Object)entity)).isRiding) {
            this.sitAnimation.applyStatic();
        }
        if (((Boolean)EnchantConfig.CLIENT.oldStyleAnimation.get()).booleanValue()) {
            if (((EnchanterRenderState)((Object)entity)).castingAnimationState.isStarted()) {
                this.oldCastingAnimation.apply(((EnchanterRenderState)((Object)entity)).castingAnimationState, ((EnchanterRenderState)((Object)entity)).ageInTicks);
                this.arms.visible = false;
                this.right_arm.visible = true;
                this.left_arm.visible = true;
            } else if (((EnchanterRenderState)((Object)entity)).attackAnimationState.isStarted()) {
                this.oldAttackAnimation.apply(((EnchanterRenderState)((Object)entity)).attackAnimationState, ((EnchanterRenderState)((Object)entity)).ageInTicks);
                this.arms.visible = true;
                this.right_arm.visible = false;
                this.left_arm.visible = false;
            } else if (!((EnchanterRenderState)((Object)entity)).castingAnimationState.isStarted() && !((EnchanterRenderState)((Object)entity)).attackAnimationState.isStarted()) {
                this.arms.visible = true;
                this.right_arm.visible = false;
                this.left_arm.visible = false;
            }
            this.right_leg.xRot = Mth.cos((float)(((EnchanterRenderState)((Object)entity)).walkAnimationPos * 0.6662f)) * 0.7f * ((EnchanterRenderState)((Object)entity)).walkAnimationSpeed;
            this.left_leg.xRot = Mth.cos((float)(((EnchanterRenderState)((Object)entity)).walkAnimationPos * 0.6662f + (float)Math.PI)) * 0.7f * ((EnchanterRenderState)((Object)entity)).walkAnimationSpeed;
        } else {
            this.arms.visible = true;
            this.right_arm.visible = true;
            this.left_arm.visible = true;
            if (((EnchanterRenderState)((Object)entity)).castingAnimationState.isStarted()) {
                this.castingAnimation.apply(((EnchanterRenderState)((Object)entity)).castingAnimationState, ((EnchanterRenderState)((Object)entity)).ageInTicks);
            } else if (((EnchanterRenderState)((Object)entity)).attackAnimationState.isStarted()) {
                this.attackAnimation.apply(((EnchanterRenderState)((Object)entity)).attackAnimationState, ((EnchanterRenderState)((Object)entity)).ageInTicks);
            } else if (!((EnchanterRenderState)((Object)entity)).castingAnimationState.isStarted() && !((EnchanterRenderState)((Object)entity)).attackAnimationState.isStarted()) {
                if (((EnchanterRenderState)((Object)entity)).idleAnimationState.isStarted()) {
                    this.idleAnimation.apply(((EnchanterRenderState)((Object)entity)).idleAnimationState, ((EnchanterRenderState)((Object)entity)).ageInTicks, 1.0f);
                } else {
                    this.walkAnimation.applyWalk(((EnchanterRenderState)((Object)entity)).walkAnimationPos, ((EnchanterRenderState)((Object)entity)).walkAnimationSpeed, 3.0f, 4.5f);
                    this.walkStopAnimation.applyStatic();
                }
            }
        }
    }

    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.3125f, 0.0f);
        poseStack.scale(1.05f, 1.05f, 1.05f);
    }

    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.75f, 0.0f);
        poseStack.scale(1.05f, 1.05f, 1.05f);
    }

    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.everything.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.scale(1.05f, 1.05f, 1.05f);
    }

    public void translateToChestPat(ModelPart modelPart, PoseStack poseStack) {
    }

    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.right_leg);
    }

    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.left_leg);
    }

    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }

    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of();
    }

    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of();
    }
}

