/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob.command;

import baguchi.enchantwithmob.api.IEnchantCap;
import baguchi.enchantwithmob.capability.MobEnchantCapability;
import baguchi.enchantwithmob.mobenchant.MobEnchant;
import baguchi.enchantwithmob.registry.MobEnchants;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class MobEnchantingCommand {
    private static final DynamicCommandExceptionType ERROR_INVALID_FEATURE = new DynamicCommandExceptionType(p_212392_ -> Component.translatable((String)"commands.place.feature.invalid", (Object[])new Object[]{p_212392_}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder enchantCommand = (LiteralArgumentBuilder)Commands.literal((String)"mob_enchanting").requires(player -> player.hasPermission(2));
        ((LiteralArgumentBuilder)enchantCommand.then(Commands.literal((String)"clear").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(ctx -> MobEnchantingCommand.setClear((CommandSourceStack)ctx.getSource(), EntityArgument.getEntity((CommandContext)ctx, (String)"target")))))).then(Commands.literal((String)"give").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(((RequiredArgumentBuilder)Commands.argument((String)"mob_enchantment", (ArgumentType)ResourceKeyArgument.key(MobEnchants.MOB_ENCHANT_REGISTRY)).executes(p_198357_0_ -> MobEnchantingCommand.setMobEnchants((CommandSourceStack)p_198357_0_.getSource(), EntityArgument.getEntity((CommandContext)p_198357_0_, (String)"target"), MobEnchantingCommand.getMobEnchant((CommandContext<CommandSourceStack>)p_198357_0_, "mob_enchantment"), 1))).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(p_198357_0_ -> MobEnchantingCommand.setMobEnchants((CommandSourceStack)p_198357_0_.getSource(), EntityArgument.getEntity((CommandContext)p_198357_0_, (String)"target"), MobEnchantingCommand.getMobEnchant((CommandContext<CommandSourceStack>)p_198357_0_, "mob_enchantment"), IntegerArgumentType.getInteger((CommandContext)p_198357_0_, (String)"level")))))));
        dispatcher.register(enchantCommand);
        LiteralArgumentBuilder ancientEnchantCommand = (LiteralArgumentBuilder)Commands.literal((String)"ancient_mob").requires(player -> player.hasPermission(2));
        ancientEnchantCommand.then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"ancient", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> MobEnchantingCommand.setAncientMob((CommandSourceStack)ctx.getSource(), EntityArgument.getEntity((CommandContext)ctx, (String)"target"), BoolArgumentType.getBool((CommandContext)ctx, (String)"ancient")))));
        dispatcher.register(ancientEnchantCommand);
    }

    public static Holder.Reference<MobEnchant> getMobEnchant(CommandContext<CommandSourceStack> p_249310_, String p_250729_) throws CommandSyntaxException {
        return MobEnchantingCommand.resolveKey(p_249310_, p_250729_, MobEnchants.MOB_ENCHANT_REGISTRY, ERROR_INVALID_FEATURE);
    }

    private static <T> Registry<T> getRegistry(CommandContext<CommandSourceStack> p_212379_, ResourceKey<? extends Registry<T>> p_212380_) {
        return ((CommandSourceStack)p_212379_.getSource()).getServer().registryAccess().lookupOrThrow(p_212380_);
    }

    private static <T> ResourceKey<T> getRegistryKey(CommandContext<CommandSourceStack> p_212374_, String p_212375_, ResourceKey<Registry<T>> p_212376_, DynamicCommandExceptionType p_212377_) throws CommandSyntaxException {
        ResourceKey resourcekey = (ResourceKey)p_212374_.getArgument(p_212375_, ResourceKey.class);
        Optional optional = resourcekey.cast(p_212376_);
        return (ResourceKey)optional.orElseThrow(() -> p_212377_.create((Object)resourcekey));
    }

    private static <T> Holder.Reference<T> resolveKey(CommandContext<CommandSourceStack> p_248662_, String p_252172_, ResourceKey<Registry<T>> p_249701_, DynamicCommandExceptionType p_249790_) throws CommandSyntaxException {
        ResourceKey resourcekey = MobEnchantingCommand.getRegistryKey(p_248662_, p_252172_, p_249701_, p_249790_);
        return (Holder.Reference)MobEnchantingCommand.getRegistry(p_248662_, p_249701_).get(resourcekey).orElseThrow(() -> p_249790_.create((Object)resourcekey.location()));
    }

    private static int setClear(CommandSourceStack commandStack, Entity entity) {
        if (entity != null) {
            if (entity instanceof LivingEntity) {
                if (entity instanceof IEnchantCap) {
                    IEnchantCap enchantCap = (IEnchantCap)entity;
                    enchantCap.getEnchantCap().removeAllMobEnchant((LivingEntity)entity);
                    enchantCap.getEnchantCap().setEnchantType((LivingEntity)entity, MobEnchantCapability.EnchantType.NORMAL);
                }
                commandStack.sendSuccess(() -> Component.translatable((String)"commands.enchantwithmob.mob_enchanting.clear", (Object[])new Object[]{entity.getDisplayName()}), true);
                return 1;
            }
            commandStack.sendFailure((Component)Component.translatable((String)"commands.enchantwithmob.mob_enchanting.clear.fail.no_living_entity", (Object[])new Object[]{entity.getDisplayName()}));
            return 0;
        }
        commandStack.sendFailure((Component)Component.translatable((String)"commands.enchantwithmob.mob_enchanting.clear.fail.no_entity"));
        return 0;
    }

    private static int setAncientMob(CommandSourceStack commandStack, Entity entity, boolean ancientMob) {
        if (entity != null) {
            if (entity instanceof LivingEntity) {
                if (entity instanceof IEnchantCap) {
                    IEnchantCap enchantCap = (IEnchantCap)entity;
                    enchantCap.getEnchantCap().setEnchantType((LivingEntity)entity, ancientMob ? MobEnchantCapability.EnchantType.ANCIENT : MobEnchantCapability.EnchantType.NORMAL);
                }
                commandStack.sendSuccess(() -> Component.translatable((String)"commands.enchantwithmob.ancient_mob.set_ancient", (Object[])new Object[]{entity.getDisplayName()}), true);
                return 1;
            }
            commandStack.sendFailure((Component)Component.translatable((String)"commands.enchantwithmob.ancient_mobb.fail.no_living_entity", (Object[])new Object[]{entity.getDisplayName()}));
            return 0;
        }
        commandStack.sendFailure((Component)Component.translatable((String)"commands.enchantwithmob.ancient_mob.fail.no_entity"));
        return 0;
    }

    private static int setMobEnchants(CommandSourceStack commandStack, Entity entity, Holder.Reference<MobEnchant> holder, int level) {
        Holder.Reference<MobEnchant> mobEnchant = holder;
        if (entity != null) {
            if (entity instanceof LivingEntity) {
                if (mobEnchant != null) {
                    if (level > 255) {
                        commandStack.sendFailure((Component)Component.translatable((String)"commands.enchantwithmob.mob_enchanting.set_enchant.fail.too_high"));
                        return 0;
                    }
                    if (entity instanceof IEnchantCap) {
                        IEnchantCap enchantCap = (IEnchantCap)entity;
                        enchantCap.getEnchantCap().addMobEnchant((LivingEntity)entity, (Holder<MobEnchant>)mobEnchant, level);
                    }
                    commandStack.sendSuccess(() -> Component.translatable((String)"commands.enchantwithmob.mob_enchanting.set_enchant", (Object[])new Object[]{entity.getDisplayName(), commandStack.registryAccess().lookupOrThrow(MobEnchants.MOB_ENCHANT_REGISTRY).getKey((Object)((MobEnchant)mobEnchant.value())).toString()}), true);
                    return 1;
                }
                commandStack.sendFailure((Component)Component.translatable((String)"commands.enchantwithmob.mob_enchanting.set_enchant.fail.no_mobenchant"));
                return 0;
            }
            commandStack.sendFailure((Component)Component.translatable((String)"commands.enchantwithmob.mob_enchanting.set_enchant.fail.no_living_entity", (Object[])new Object[]{entity.getDisplayName()}));
            return 0;
        }
        commandStack.sendFailure((Component)Component.translatable((String)"commands.enchantwithmob.mob_enchanting.set_enchant.fail.no_entity"));
        return 0;
    }
}

