/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob.data;

import baguchi.enchantwithmob.data.BlockTagGenerator;
import baguchi.enchantwithmob.data.CraftingGenerator;
import baguchi.enchantwithmob.data.CustomTagProvider;
import baguchi.enchantwithmob.data.EntityTagGenerator;
import baguchi.enchantwithmob.data.ItemTagGenerator;
import baguchi.enchantwithmob.data.RegistryDataGenerator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="enchantwithmob")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        RegistryDataGenerator datapackProvider = new RegistryDataGenerator(packOutput, event.getLookupProvider());
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(true, (DataProvider)datapackProvider);
        BlockTagGenerator blockTagsProvider = new BlockTagGenerator(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)blockTagsProvider);
        generator.addProvider(true, (DataProvider)new ItemTagGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new EntityTagGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new CustomTagProvider.MobEnchantTagGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new Runner(packOutput, lookupProvider));
    }

    public static final class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider lookupProvider, RecipeOutput output) {
            return new CraftingGenerator(lookupProvider, output);
        }

        public String getName() {
            return "enchantwithmobrecipes";
        }
    }
}

