/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob.item;

import baguchi.enchantwithmob.EnchantConfig;
import baguchi.enchantwithmob.api.IEnchantCap;
import baguchi.enchantwithmob.registry.ModDataCompnents;
import baguchi.enchantwithmob.registry.ModItems;
import baguchi.enchantwithmob.utils.MobEnchantUtils;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EnchanterBottleItem
extends Item {
    public EnchanterBottleItem(Item.Properties group) {
        super(group);
    }

    public boolean isEnabled(FeatureFlagSet p_249172_) {
        return super.isEnabled(p_249172_) && (Boolean)EnchantConfig.COMMON.disableMobEnchantStuffItems.get() == false;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        Player player;
        ItemStack stack1 = new ItemStack((ItemLike)ModItems.ENCHANATERS_EXPERIENCE_BOTTLE.get());
        if (entity instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)entity;
            int xp = 0;
            if (!cap.getEnchantCap().isAncient() && cap.getEnchantCap().hasEnchant()) {
                if ((xp += MobEnchantUtils.getExperienceFromMob(cap)) > 0) {
                    stack1.set((DataComponentType)ModDataCompnents.EXPERIENCE.get(), (Object)xp);
                }
                if (cap.getEnchantCap().hasOwner()) {
                    cap.getEnchantCap().removeOwner(entity);
                }
                MobEnchantUtils.removeMobEnchantToEntity(entity, cap);
                entity.playSound(SoundEvents.ENCHANTMENT_TABLE_USE, 1.0f, 1.0f);
            }
            if (xp <= 0 && entity instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)entity;
                if (serverplayer.totalExperience >= 30) {
                    stack1.set((DataComponentType)ModDataCompnents.EXPERIENCE.get(), (Object)30);
                    serverplayer.giveExperiencePoints(-30);
                } else if (serverplayer.totalExperience > 0) {
                    stack1.set((DataComponentType)ModDataCompnents.EXPERIENCE.get(), (Object)serverplayer.totalExperience);
                    serverplayer.giveExperiencePoints(-serverplayer.totalExperience);
                } else {
                    return stack;
                }
            }
        }
        stack.consume(1, entity);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            CriteriaTriggers.USING_ITEM.trigger(serverplayer, stack);
            serverplayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (stack.isEmpty()) {
            return stack1;
        }
        if (entity instanceof Player && !(player = (Player)entity).hasInfiniteMaterials() && !player.getInventory().add(stack1)) {
            player.drop(stack1, false);
        }
        return stack;
    }

    public InteractionResult use(Level p_41352_, Player p_41353_, InteractionHand p_41354_) {
        IEnchantCap cap;
        int xp;
        if (p_41353_ instanceof IEnchantCap && (xp = MobEnchantUtils.getExperienceFromMob(cap = (IEnchantCap)p_41353_)) > 0) {
            return ItemUtils.startUsingInstantly((Level)p_41352_, (Player)p_41353_, (InteractionHand)p_41354_);
        }
        if (p_41353_.totalExperience > 0) {
            return ItemUtils.startUsingInstantly((Level)p_41352_, (Player)p_41353_, (InteractionHand)p_41354_);
        }
        return super.use(p_41352_, p_41353_, p_41354_);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer1, TooltipFlag flag) {
        super.appendHoverText(stack, tooltipContext, tooltipDisplay, consumer1, flag);
        ChatFormatting[] textformatting2 = new ChatFormatting[]{ChatFormatting.DARK_PURPLE};
        consumer1.accept((Component)Component.translatable((String)"mobenchant.enchantwithmob.enchanters_bottle.tooltip").withStyle(textformatting2));
    }

    public int getUseDuration(ItemStack p_40680_, LivingEntity p_345962_) {
        return 30;
    }

    public ItemUseAnimation getUseAnimation(ItemStack p_41452_) {
        return ItemUseAnimation.DRINK;
    }
}

