/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob.item;

import baguchi.enchantwithmob.EnchantConfig;
import baguchi.enchantwithmob.api.IEnchantCap;
import baguchi.enchantwithmob.registry.ModDataCompnents;
import baguchi.enchantwithmob.utils.MobEnchantUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class EnchantersBookItem
extends Item {
    private final TargetingConditions enchantTargeting = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
    private final TargetingConditions alreadyEnchantTargeting = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting().selector((server, entity) -> {
        IEnchantCap enchantCap;
        return entity instanceof IEnchantCap && (enchantCap = (IEnchantCap)entity).getEnchantCap().hasEnchant();
    });

    public EnchantersBookItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isEnabled(FeatureFlagSet p_249172_) {
        return super.isEnabled(p_249172_) && (Boolean)EnchantConfig.COMMON.disableMobEnchantStuffItems.get() == false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (!MobEnchantUtils.hasMobEnchant(stack)) return super.use(level, playerIn, handIn);
        List list = level.getEntitiesOfClass(LivingEntity.class, playerIn.getBoundingBox().inflate(16.0));
        List hasEnchantedMoblist = level.getEntitiesOfClass(LivingEntity.class, playerIn.getBoundingBox().inflate(16.0), entity -> {
            IEnchantCap enchantCap;
            return entity instanceof IEnchantCap && (enchantCap = (IEnchantCap)entity).getEnchantCap().hasEnchant();
        });
        if (hasEnchantedMoblist.isEmpty() || hasEnchantedMoblist.size() < 5) {
            if (!list.isEmpty()) {
                int size = list.size();
                boolean[] flag = new boolean[]{false};
                for (int i = 0; i < size; ++i) {
                    IEnchantCap cap;
                    LivingEntity enchantedMob = (LivingEntity)list.get(i);
                    if (i >= 5) break;
                    if (enchantedMob.canAttack((LivingEntity)playerIn) || playerIn == enchantedMob || !(enchantedMob instanceof IEnchantCap) || (cap = (IEnchantCap)enchantedMob).getEnchantCap().hasEnchant()) continue;
                    if (flag[0]) {
                        MobEnchantUtils.addUnstableItemMobEnchantToEntity(stack, enchantedMob, (LivingEntity)playerIn, cap);
                        continue;
                    }
                    flag[0] = MobEnchantUtils.addUnstableItemMobEnchantToEntity(stack, enchantedMob, (LivingEntity)playerIn, cap);
                }
                if (!flag[0]) return super.use(level, playerIn, handIn);
                level.playSound((Entity)playerIn, playerIn.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS);
                playerIn.getCooldowns().addCooldown(stack, 40);
                return InteractionResult.SUCCESS;
            }
            playerIn.displayClientMessage((Component)Component.translatable((String)"enchantwithmob.cannot.no_enchantable_ally"), true);
            playerIn.getCooldowns().addCooldown(stack, 20);
            return InteractionResult.FAIL;
        }
        playerIn.displayClientMessage((Component)Component.translatable((String)"enchantwithmob.cannot.no_enchantable_ally"), true);
        playerIn.getCooldowns().addCooldown(stack, 20);
        return InteractionResult.FAIL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer1, TooltipFlag flag) {
        super.appendHoverText(stack, tooltipContext, tooltipDisplay, consumer1, flag);
        ChatFormatting[] textformatting2 = new ChatFormatting[]{ChatFormatting.DARK_PURPLE};
        stack.addToTooltip((DataComponentType)ModDataCompnents.MOB_ENCHANTMENTS.get(), tooltipContext, tooltipDisplay, consumer1, flag);
        consumer1.accept((Component)Component.translatable((String)"mobenchant.enchantwithmob.enchanter_book.tooltip").withStyle(textformatting2));
    }

    public boolean isFoil(ItemStack p_77636_1_) {
        return true;
    }
}

