/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob.item;

import baguchi.enchantwithmob.EnchantConfig;
import baguchi.enchantwithmob.api.IEnchantCap;
import baguchi.enchantwithmob.mobenchant.MobEnchant;
import baguchi.enchantwithmob.registry.ModDataCompnents;
import baguchi.enchantwithmob.registry.ModItems;
import baguchi.enchantwithmob.utils.MobEnchantUtils;
import baguchi.enchantwithmob.utils.MobEnchantmentData;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class MobEnchantBookItem
extends Item {
    public MobEnchantBookItem(Item.Properties group) {
        super(group);
    }

    public boolean isEnabled(FeatureFlagSet p_249172_) {
        return super.isEnabled(p_249172_) && (Boolean)EnchantConfig.COMMON.disableMobEnchantStuffItems.get() == false;
    }

    public InteractionResult use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (((Boolean)EnchantConfig.COMMON.enchantYourSelf.get()).booleanValue() && MobEnchantUtils.hasMobEnchant(stack) && playerIn instanceof IEnchantCap) {
            IEnchantCap cap = (IEnchantCap)playerIn;
            boolean flag = MobEnchantUtils.addItemMobEnchantToEntity(stack, (LivingEntity)playerIn, (LivingEntity)playerIn, cap);
            if (flag) {
                level.playSound((Entity)playerIn, playerIn.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS);
                playerIn.getCooldowns().addCooldown(stack, 40);
                return InteractionResult.SUCCESS;
            }
            playerIn.displayClientMessage((Component)Component.translatable((String)"enchantwithmob.cannot.enchant_yourself"), true);
            playerIn.getCooldowns().addCooldown(stack, 20);
            return InteractionResult.FAIL;
        }
        return super.use(level, playerIn, handIn);
    }

    public static ItemStack createMobEnchantBook(MobEnchantmentData p_363915_) {
        ItemStack itemstack = new ItemStack((ItemLike)ModItems.MOB_ENCHANT_BOOK.asItem());
        MobEnchantUtils.enchant(p_363915_.enchantment, itemstack, p_363915_.enchantmentLevel);
        return itemstack;
    }

    public static ItemStack createEnchanterBook(MobEnchantmentData p_363915_) {
        ItemStack itemstack = new ItemStack((ItemLike)ModItems.ENCHANTERS_BOOK.asItem());
        MobEnchantUtils.enchant(p_363915_.enchantment, itemstack, p_363915_.enchantmentLevel);
        return itemstack;
    }

    public static void generateEnchantmentBookTypesOnlyMaxLevel(BuildCreativeModeTabContentsEvent output, HolderLookup<MobEnchant> enchantments, CreativeModeTab.TabVisibility tabVisibility) {
        enchantments.listElements().map(p_360016_ -> MobEnchantBookItem.createMobEnchantBook(new MobEnchantmentData((Holder<MobEnchant>)p_360016_, ((MobEnchant)p_360016_.value()).getMaxLevel()))).forEach(p_269989_ -> output.accept(p_269989_, tabVisibility));
        enchantments.listElements().map(p_360016_ -> MobEnchantBookItem.createEnchanterBook(new MobEnchantmentData((Holder<MobEnchant>)p_360016_, ((MobEnchant)p_360016_.value()).getMaxLevel()))).forEach(p_269989_ -> output.accept(p_269989_, tabVisibility));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer1, TooltipFlag flag) {
        super.appendHoverText(stack, tooltipContext, tooltipDisplay, consumer1, flag);
        ChatFormatting[] textformatting2 = new ChatFormatting[]{ChatFormatting.DARK_PURPLE};
        stack.addToTooltip((DataComponentType)ModDataCompnents.MOB_ENCHANTMENTS.get(), tooltipContext, tooltipDisplay, consumer1, flag);
        consumer1.accept((Component)Component.translatable((String)"mobenchant.enchantwithmob.mob_enchant_book.tooltip").withStyle(textformatting2));
    }

    public boolean isFoil(ItemStack p_77636_1_) {
        return true;
    }
}

