/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob.item.mobenchant;

import baguchi.enchantwithmob.mobenchant.MobEnchant;
import baguchi.enchantwithmob.registry.MobEnchants;
import baguchi.enchantwithmob.registry.ModTags;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.TooltipProvider;

public class ItemMobEnchantments
implements TooltipProvider {
    public static final ItemMobEnchantments EMPTY = new ItemMobEnchantments((Object2IntOpenHashMap<Holder<MobEnchant>>)new Object2IntOpenHashMap(), true);
    public static final int MAX_LEVEL = 255;
    private static final Codec<Integer> LEVEL_CODEC = Codec.intRange((int)0, (int)255);
    private static final Codec<Object2IntOpenHashMap<Holder<MobEnchant>>> LEVELS_CODEC = Codec.unboundedMap((Codec)MobEnchants.getRegistry().holderByNameCodec(), LEVEL_CODEC).xmap(Object2IntOpenHashMap::new, Function.identity());
    private static final Codec<ItemMobEnchantments> FULL_CODEC = RecordCodecBuilder.create(p_337961_ -> p_337961_.group((App)LEVELS_CODEC.fieldOf("levels").forGetter(p_340785_ -> p_340785_.enchantments), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(p_331891_ -> p_331891_.showInTooltip)).apply((Applicative)p_337961_, ItemMobEnchantments::new));
    public static final Codec<ItemMobEnchantments> CODEC = Codec.withAlternative(FULL_CODEC, LEVELS_CODEC, p_340783_ -> new ItemMobEnchantments((Object2IntOpenHashMap<Holder<MobEnchant>>)p_340783_, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemMobEnchantments> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Object2IntOpenHashMap::new, (StreamCodec)ByteBufCodecs.holderRegistry(MobEnchants.MOB_ENCHANT_REGISTRY), (StreamCodec)ByteBufCodecs.VAR_INT), p_340784_ -> p_340784_.enchantments, (StreamCodec)ByteBufCodecs.BOOL, p_330450_ -> p_330450_.showInTooltip, ItemMobEnchantments::new);
    final Object2IntOpenHashMap<Holder<MobEnchant>> enchantments;
    final boolean showInTooltip;

    ItemMobEnchantments(Object2IntOpenHashMap<Holder<MobEnchant>> p_341287_, boolean p_330219_) {
        Object2IntMap.Entry entry;
        int i;
        this.enchantments = p_341287_;
        this.showInTooltip = p_330219_;
        ObjectIterator var3 = p_341287_.object2IntEntrySet().iterator();
        do {
            if (var3.hasNext()) continue;
            return;
        } while ((i = (entry = (Object2IntMap.Entry)var3.next()).getIntValue()) >= 0 && i <= 255);
        String var10002 = String.valueOf(entry.getKey());
        throw new IllegalArgumentException("Enchantment " + var10002 + " has invalid level " + i);
    }

    public int getLevel(MobEnchant p_330552_) {
        return this.enchantments.getInt(ItemMobEnchantments.getHolder(p_330552_));
    }

    public void addToTooltip(Item.TooltipContext tooltipContext, Consumer<Component> consumer, TooltipFlag tooltipFlag, DataComponentGetter dataComponentGetter) {
        ArrayList list = Lists.newArrayList();
        if (this.showInTooltip) {
            HolderLookup.Provider holderlookup$provider = tooltipContext.registries();
            HolderSet<MobEnchant> holderset = ItemMobEnchantments.getTagOrEmpty(holderlookup$provider, MobEnchants.MOB_ENCHANT_REGISTRY, ModTags.MobEnchantTags.TOOLTIP_ORDER);
            for (Holder holder : holderset) {
                int i = this.enchantments.getInt((Object)holder);
                if (i <= 0) continue;
                ((MobEnchant)holder.value()).createModifiers(i, (p_331556_, p_330860_) -> list.add(new Pair(p_331556_, p_330860_)));
                consumer.accept(((MobEnchant)holder.value()).getFullname(i));
            }
            for (Object2IntMap.Entry entry : this.enchantments.object2IntEntrySet()) {
                Holder holder1 = (Holder)entry.getKey();
                if (holderset.contains(holder1)) continue;
                consumer.accept(((MobEnchant)holder1.value()).getFullname(entry.getIntValue()));
            }
        }
        if (!list.isEmpty()) {
            consumer.accept(CommonComponents.EMPTY);
            consumer.accept((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list) {
                AttributeModifier attributemodifier = (AttributeModifier)pair.getSecond();
                double d1 = attributemodifier.amount();
                double d0 = attributemodifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && attributemodifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? attributemodifier.amount() : attributemodifier.amount() * 100.0;
                if (d1 > 0.0) {
                    consumer.accept((Component)Component.translatable((String)("attribute.modifier.plus." + attributemodifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d0), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d1 < 0.0)) continue;
                consumer.accept((Component)Component.translatable((String)("attribute.modifier.take." + attributemodifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d0 *= -1.0), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.RED));
            }
        }
    }

    private static <T> HolderSet<T> getTagOrEmpty(@Nullable HolderLookup.Provider p_341186_, ResourceKey<Registry<T>> p_341113_, TagKey<T> p_341409_) {
        Optional optional;
        if (p_341186_ != null && (optional = p_341186_.lookupOrThrow(p_341113_).get(p_341409_)).isPresent()) {
            return (HolderSet)optional.get();
        }
        return HolderSet.direct((Holder[])new Holder[0]);
    }

    public ItemMobEnchantments withTooltip(boolean p_335616_) {
        return new ItemMobEnchantments(this.enchantments, p_335616_);
    }

    public Set<Holder<MobEnchant>> keySet() {
        return Collections.unmodifiableSet(this.enchantments.keySet());
    }

    public Set<Object2IntMap.Entry<Holder<MobEnchant>>> entrySet() {
        return Collections.unmodifiableSet(this.enchantments.object2IntEntrySet());
    }

    public int size() {
        return this.enchantments.size();
    }

    public boolean isEmpty() {
        return this.enchantments.isEmpty();
    }

    public boolean equals(Object p_331697_) {
        boolean var10000;
        if (this == p_331697_) {
            return true;
        }
        if (p_331697_ instanceof ItemMobEnchantments) {
            ItemMobEnchantments itemenchantments = (ItemMobEnchantments)p_331697_;
            var10000 = this.showInTooltip == itemenchantments.showInTooltip && this.enchantments.equals(itemenchantments.enchantments);
        } else {
            var10000 = false;
        }
        return var10000;
    }

    public int hashCode() {
        int i = this.enchantments.hashCode();
        return 31 * i + (this.showInTooltip ? 1 : 0);
    }

    public String toString() {
        String var10000 = String.valueOf(this.enchantments);
        return "ItemMobEnchantments{enchantments=" + var10000 + ", showInTooltip=" + this.showInTooltip + "}";
    }

    public static Holder<MobEnchant> getHolder(MobEnchant mobEnchant) {
        return MobEnchants.getRegistry().wrapAsHolder((Object)mobEnchant);
    }

    public static class Mutable {
        private final Object2IntOpenHashMap<Holder<MobEnchant>> enchantments = new Object2IntOpenHashMap();
        private final boolean showInTooltip;

        public Mutable(ItemMobEnchantments p_330722_) {
            this.enchantments.putAll(p_330722_.enchantments);
            this.showInTooltip = p_330722_.showInTooltip;
        }

        public void set(MobEnchant p_331872_, int p_330832_) {
            if (p_330832_ <= 0) {
                this.enchantments.removeInt(ItemMobEnchantments.getHolder(p_331872_));
            } else {
                this.enchantments.put(ItemMobEnchantments.getHolder(p_331872_), Math.min(p_330832_, 255));
            }
        }

        public void upgrade(MobEnchant p_330536_, int p_331153_) {
            if (p_331153_ > 0) {
                this.enchantments.merge(ItemMobEnchantments.getHolder(p_330536_), Math.min(p_331153_, 255), Integer::max);
            }
        }

        public void removeIf(Predicate<Holder<MobEnchant>> p_332079_) {
            this.enchantments.keySet().removeIf(p_332079_);
        }

        public int getLevel(MobEnchant p_331330_) {
            return this.enchantments.getOrDefault(ItemMobEnchantments.getHolder(p_331330_), 0);
        }

        public Set<Holder<MobEnchant>> keySet() {
            return this.enchantments.keySet();
        }

        public ItemMobEnchantments toImmutable() {
            return new ItemMobEnchantments(this.enchantments, this.showInTooltip);
        }
    }
}

