/*
 * Decompiled with CFR 0.152.
 */
package baguchi.enchantwithmob.loot;

import baguchi.enchantwithmob.mobenchant.MobEnchant;
import baguchi.enchantwithmob.registry.MobEnchants;
import baguchi.enchantwithmob.registry.ModItems;
import baguchi.enchantwithmob.registry.ModLootItemFunctions;
import baguchi.enchantwithmob.registry.ModTags;
import baguchi.enchantwithmob.utils.MobEnchantUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class MobEnchantRandomlyFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<MobEnchantRandomlyFunction> CODEC = RecordCodecBuilder.mapCodec(p_344688_ -> MobEnchantRandomlyFunction.commonFields((RecordCodecBuilder.Instance)p_344688_).and(p_344688_.group((App)RegistryCodecs.homogeneousList(MobEnchants.MOB_ENCHANT_REGISTRY).optionalFieldOf("options").forGetter(p_344687_ -> p_344687_.options), (App)Codec.BOOL.optionalFieldOf("only_compatible", (Object)true).forGetter(p_344689_ -> p_344689_.onlyCompatible))).apply((Applicative)p_344688_, MobEnchantRandomlyFunction::new));
    private final Optional<HolderSet<MobEnchant>> options;
    private final boolean onlyCompatible;

    public MobEnchantRandomlyFunction(List<LootItemCondition> conditons, Optional<HolderSet<MobEnchant>> options, boolean onlyCompatible) {
        super(conditons);
        this.options = options;
        this.onlyCompatible = onlyCompatible;
    }

    public LootItemFunctionType<MobEnchantRandomlyFunction> getType() {
        return ModLootItemFunctions.MOB_ENCHANT_RANDOMLY_FUNCTION.get();
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        RandomSource randomsource = context.getRandom();
        boolean flag = stack.is(ModItems.MOB_ENCHANT_BOOK);
        boolean flag1 = !flag && this.onlyCompatible;
        Stream<Holder> stream = this.options.map(HolderSet::stream).orElseGet(() -> context.getLevel().registryAccess().lookupOrThrow(MobEnchants.MOB_ENCHANT_REGISTRY).listElements().map(Function.identity())).filter(p_344686_ -> !flag1);
        List<Holder> list = stream.toList();
        Optional optional = Util.getRandomSafe(list, (RandomSource)randomsource);
        if (optional.isEmpty()) {
            LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)stack);
            return stack;
        }
        return MobEnchantRandomlyFunction.enchantItem(stack, (Holder<MobEnchant>)((Holder)optional.get()), randomsource);
    }

    private static ItemStack enchantItem(ItemStack stack, Holder<MobEnchant> enchantment, RandomSource random) {
        int i = Mth.nextInt((RandomSource)random, (int)((MobEnchant)enchantment.value()).getMinLevel(), (int)((MobEnchant)enchantment.value()).getMaxLevel());
        if (stack.is(Items.BOOK)) {
            stack = new ItemStack((ItemLike)ModItems.MOB_ENCHANT_BOOK.asItem());
        }
        MobEnchantUtils.enchant(enchantment, stack, i);
        return stack;
    }

    public static Builder randomMobEnchant() {
        return new Builder();
    }

    public static Builder randomApplicableMobEnchant(HolderLookup.Provider registries) {
        return MobEnchantRandomlyFunction.randomMobEnchant().withOneOf((HolderSet<MobEnchant>)registries.lookupOrThrow(MobEnchants.MOB_ENCHANT_REGISTRY).getOrThrow(ModTags.MobEnchantTags.RANDOM_LOOT));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private Optional<HolderSet<MobEnchant>> options = Optional.empty();
        private boolean onlyCompatible = true;

        protected Builder getThis() {
            return this;
        }

        public Builder withMobEnchant(Holder<MobEnchant> enchantment) {
            this.options = Optional.of(HolderSet.direct((Holder[])new Holder[]{enchantment}));
            return this;
        }

        public Builder withOneOf(HolderSet<MobEnchant> enchantments) {
            this.options = Optional.of(enchantments);
            return this;
        }

        public Builder allowingIncompatibleMobEnchants() {
            this.onlyCompatible = false;
            return this;
        }

        public LootItemFunction build() {
            return new MobEnchantRandomlyFunction(this.getConditions(), this.options, this.onlyCompatible);
        }
    }
}

